package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 地区信息关联信息
 * @author liujia
 */
@ApiModel(description = "地区关联信息")
public class LocationRelationBean extends BaseBean {
    @ApiModelProperty("关联信息ID")
    private Long id;

    @ApiModelProperty(value = "地区编码", hidden = true)
    @JsonIgnore
    private String locationCode;

    @ApiModelProperty(value = "关联信息内容（如微信话术、朋友圈话术）")
    private String content;

    @ApiModelProperty(value = "关联信息类型，1：微信分享话术，2：朋友圈话术", allowableValues = "1,2", hidden = true)
    private Byte type;

    @ApiModelProperty(value = "创建时间", hidden = true)
    @JsonIgnore
    private Date createTime;

    public LocationRelationBean() {
    }

    public LocationRelationBean(Long id, String content) {
        this.id = id;
        this.content = content;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
