package com.bxm.localnews.admin.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(description = "广告位置(投放)DTO")
@Data
public class AdvertPositionDTO {

    @ApiModelProperty("广告id")
    private Long id;

    @ApiModelProperty("广告名称")
    private String advertName;

    @ApiModelProperty("投放位置类型,1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 5：赚钱中心公告 6：首页悬浮广告 7:开屏广告 8:首页配置广告 9:签到页面轮播广告 10:消息中心轮播广告 11:社区首页文字广告")
    private Integer positionType;

    @ApiModelProperty("投放位置类型中文名称")
    private String positionTypeStr;

    @ApiModelProperty("全国投放状态,1-全国投放，0-非全国投放")
    private Integer globalStatus;

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Integer showType;

    @ApiModelProperty("广告素材信息List")
    private List<AdvertMaterialInfo> materialList;

    @ApiModelProperty("是否上架（1：是，0：否）")
    private Integer enableStatus;

    @ApiModelProperty("广告地区列表")
    private List<AdvertAreaDTO> areaList;

    @ApiModelProperty("倒计时")
    private Integer timeout;

    @ApiModelProperty("投放对象")
    private String deliveryObject;
}
