package com.bxm.localnews.admin.dto;

import com.bxm.localnews.admin.vo.LocationRelationBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@ApiModel(description = "区域详情实体")
@Data
public class AreaInfoDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("一级区域编码")
    private String provinceCode;

    @ApiModelProperty("一级区域名称")
    private String provinceName;

    @ApiModelProperty("二级区域编码")
    private String code;

    @ApiModelProperty("二级区域名称")
    private String name;

    @ApiModelProperty("常住人口")
    private String population;

    @ApiModelProperty("地区描述（文案性质的描述），支持html")
    private String description;

    @ApiModelProperty("覆盖率")
    private String coverRate;

    @ApiModelProperty("传播率")
    private String transmissionRate;

    @ApiModelProperty(value = "是否启用VIP，1：启用，0：禁用", allowableValues = "0,1")
    private Byte enableVip;

    @ApiModelProperty(value = "VIP总价值")
    private String value;

    @ApiModelProperty(value = "激活VIP需要邀请人数")
    private int invitedCount;

    @ApiModelProperty("是否启用推广赚钱")
    private Byte enablePaidPromote;

    @ApiModelProperty("新人红包金额")
    private BigDecimal newRedPacket;

    @ApiModelProperty("推广赏金")
    private BigDecimal promoteBounty;

    @ApiModelProperty(value = "微信分享话术配置项")
    private List<LocationRelationBean> shareWechatSeg;

    @ApiModelProperty(value = "微信分享图片配置项")
    private List<LocationRelationBean> shareWechatImgSeg;

    @ApiModelProperty(value = "微信朋友圈分享话术配置项")
    private List<LocationRelationBean> shareMomentSeg;

    @ApiModelProperty(value = "微信朋友圈图片配置项")
    private List<LocationRelationBean> shareMomentImgSeg;

    @ApiModelProperty(value = "微信小程序分享话术配置项")
    private List<LocationRelationBean> shareMiniAppWechatSeg;

    @ApiModelProperty(value = "微信小程序分享图片配置项")
    private List<LocationRelationBean> shareMiniAppWechatImgSeg;

    @ApiModelProperty(value = "微信小程序朋友圈分享话术配置项")
    private List<LocationRelationBean> shareMiniAppMomentSeg;

    @ApiModelProperty(value = "微信小程序朋友圈图片配置项")
    private List<LocationRelationBean> shareMiniAppMomentImgSeg;

    @ApiModelProperty(value = "提醒召回小程序分享")
    private List<LocationRelationBean> recallMiniAppWechatImgSeg;

    @ApiModelProperty(value = "提醒召回小程序图片分享")
    private List<LocationRelationBean> recallMiniAppMomentImgSeg;


    @ApiModelProperty(value = "是否启用社区内容，1：启用，0：禁用")
    private Integer enableCommunityContent;

    @ApiModelProperty(value = "是否启用首页发帖，1：启用，0：禁用")
    private Integer enableIndexPublish;

    @ApiModelProperty(value = "是否启用客服小助手，1：启用，0：禁用")
    private Integer enableCustomerService;

    @ApiModelProperty(value = "客服信息列表")
    private List<LocationRelationBean> customerServiceInfo;

    @ApiModelProperty("是否开启聊天室 0:关闭  1:开启")
    private Byte enableChatRoom;

    @ApiModelProperty("是否开启定时红包 0:关闭  1:开启")
    private Byte enableTimingRedPacket;

    @ApiModelProperty(value = "聊天室分享配置")
    private List<LocationRelationBean> chatRoomImgSeg;

    @ApiModelProperty(value = "聊天室id")
    private String chatRoomId;

    @ApiModelProperty("聊天室虚拟人数最小值")
    private Integer startIntervalNumber;

    @ApiModelProperty("聊天室虚拟人数最大值")
    private Integer endIntervalNumber;
}