package com.bxm.localnews.admin.dto;

import com.bxm.localnews.admin.vo.VirtualUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

@ApiModel("聊天马甲返回实体")
@Data
public class ChatVirtualUserDTO extends VirtualUser implements Comparable<ChatVirtualUserDTO> {

    @ApiModelProperty("未回复数量")
    private Integer unReplyNum;

    @ApiModelProperty("最近回复时间")
    private Date recentTime;

    @Override
    public int compareTo(ChatVirtualUserDTO o) {
        if (Objects.isNull(o)){
            return 1;
        }
        int result = o.getUnReplyNum().compareTo(this.getUnReplyNum());
        if (result == 0){
            if (Objects.nonNull(this.getRecentTime()) && Objects.nonNull(o.getRecentTime()) ){
                result = o.getRecentTime().compareTo(this.getRecentTime());
            }

            if (Objects.nonNull(this.getRecentTime()) && Objects.isNull(o.getRecentTime()) ){
                result = -1;
            }
            if (Objects.isNull(this.getRecentTime()) && Objects.nonNull(o.getRecentTime()) ){
                result = 1;
            }

            if ((Objects.isNull(this.getRecentTime()) && Objects.isNull(o.getRecentTime()) )){
                result = o.getId().compareTo(this.getId());
            }
        }
        return result;
    }
}
