package com.bxm.localnews.admin.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel("用户信息")
@Data
public class UserInfoDTO extends BaseBean {

    private String userId;

    private String userName;

    private String idCardNo;

    private Integer isMember;

    private String startTime;

    private String endTime;

    private String registerClient;

    private String channelId;

    private String channelName;

    private String phone;

    private Integer state;

    private Date registTime;

    /**
     * 用户头像
     */
    private String headImg;

    /**
     * 用户地区名称
     */
    private String locationName;

    @ApiModelProperty("用户角色列表")
    private List<String> roles;
}

