package com.bxm.localnews.admin.dto;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/13 11:22
 * @desc
 */
@ApiModel(description = "提现用户相关信息")
public class WithdrawUserInfo {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("提现对应的openid")
    private String openId;

    @ApiModelProperty("注册渠道 地区+邀请关系")
    private String registerChannel;

    @ApiModelProperty("下载渠道")
    private String channel;

    @ApiModelProperty("注册时间")
    private Date createTime;

    @ApiModelProperty("注册ip")
    private String regIp;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("上次登录时间")
    private Date lastLginTime;

    @ApiModelProperty("上次登录ip")
    private String lastLoginIp;

    @ApiModelProperty("上次登录设备号")
    private String lastLoginEquipment;

    @ApiModelProperty("当前选择城市")
    private String areaName;

    @ApiModelProperty("成功邀请关系")
    private Integer successInviteNum = 0;

    @ApiModelProperty("累计收入")
    private BigDecimal totalCash = BigDecimal.ZERO;

    @ApiModelProperty("成功提现")
    private BigDecimal withdrawalCash = BigDecimal.ZERO;

    @ApiModelProperty("可提现")
    private BigDecimal drawablelCash = BigDecimal.ZERO;

    @ApiModelProperty("在路上总赏金")
    private BigDecimal availableCash = BigDecimal.ZERO;

    @ApiModelProperty("已作废总赏金")
    private BigDecimal discardCash = BigDecimal.ZERO;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getRegisterChannel() {
        return registerChannel;
    }

    public void setRegisterChannel(String registerChannel) {
        this.registerChannel = registerChannel;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRegIp() {
        return regIp;
    }

    public void setRegIp(String regIp) {
        this.regIp = regIp;
    }

    public String getEquipment() {
        return equipment;
    }

    public void setEquipment(String equipment) {
        this.equipment = equipment;
    }

    public Date getLastLginTime() {
        return lastLginTime;
    }

    public void setLastLginTime(Date lastLginTime) {
        this.lastLginTime = lastLginTime;
    }

    public String getLastLoginIp() {
        return lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    public String getLastLoginEquipment() {
        return lastLoginEquipment;
    }

    public void setLastLoginEquipment(String lastLoginEquipment) {
        this.lastLoginEquipment = lastLoginEquipment;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public Integer getSuccessInviteNum() {
        return successInviteNum;
    }

    public void setSuccessInviteNum(Integer successInviteNum) {
        this.successInviteNum = successInviteNum;
    }

    public BigDecimal getTotalCash() {
        return totalCash;
    }

    public void setTotalCash(BigDecimal totalCash) {
        this.totalCash = totalCash;
    }

    public BigDecimal getWithdrawalCash() {
        return withdrawalCash;
    }

    public void setWithdrawalCash(BigDecimal withdrawalCash) {
        this.withdrawalCash = withdrawalCash;
    }

    public BigDecimal getDrawablelCash() {
        return drawablelCash;
    }

    public void setDrawablelCash(BigDecimal drawablelCash) {
        this.drawablelCash = drawablelCash;
    }

    public BigDecimal getAvailableCash() {
        return availableCash;
    }

    public void setAvailableCash(BigDecimal availableCash) {
        this.availableCash = availableCash;
    }

    public BigDecimal getDiscardCash() {
        return discardCash;
    }

    public void setDiscardCash(BigDecimal discardCash) {
        this.discardCash = discardCash;
    }
}
