package com.bxm.localnews.admin.entry;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class ImTimingRedPacketPlan {
    private Long id;

    /**
     * 红包名称
     */
    private String redPacketName;

    /**
     * 红包寄语
     */
    private String redPacketRemark;

    /**
     * 红包金额类型 1：现金红包
     */
    private Byte redPacketAmountType;

    /**
     * 红包类型：1：群聊红包 2：个人红包
     */
    private Byte redPacketType;

    /**
     * 目标id（群聊红包：聊天室id，个人红包：用户id）
     */
    private String redPacketTargetId;

    /**
     * 发送红包用户id
     */
    private Long redPacketSourceUserId;

    /**
     * 领取用户类型：1：邀请好友之后可领取
     */
    private Byte redPacketAuthType;

    /**
     * 红包派发生成策略（群聊红包可用）：1：每个用户可获得0.1~总金额 / 总个数 * 2区间内的金额
     */
    private Byte redPacketDistributeArithmeticType;

    /**
     * 红包来源：1：管理后台配置 2：App用户发送
     */
    private Byte redPacketSource;

    /**
     * 定时类型：1：每日定时发送 2：指定日期与时间发送
     */
    private Byte timingType;

    /**
     * 如果是指定日期，则有效
     */
    private Date sentDate;

    /**
     * 每日定时发送的时间
     */
    private Date sentTime;

    /**
     * 发送总次数 -1为无限次
     */
    private Integer totalTimes;

    /**
     * 已发送次数
     */
    private Integer sendTimes;

    /**
     * 红包金额 单位元
     */
    private BigDecimal redPacketTotalAmount;

    /**
     * 红包总可领取数
     */
    private Integer redPacketTotalNum;

    /**
     * 状态：1：正常
     */
    private Byte status;

    /**
     * 删除状态：0：未删除 1：已删除
     */
    private Byte deleteFlag;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 最后修改时间
     */
    private Date modifyTime;

    /**
     * 创建时间
     */
    private Date createTime;
}