package com.bxm.localnews.admin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode
@ApiModel(description = "马甲号批量发送消息参数")
public class BatchMessageParam {
    @ApiModelProperty("发送消息类型,RC:TxtMsg 文本消息, RC:ImgMsg 图片消息(只支持jpg格式图片)")
    private String objectName;

    @ApiModelProperty("发送类型的内容")
    private String content;

    @ApiModelProperty("发送马甲号的用户id")
    private Long fromUserId;

    @ApiModelProperty("接收消息的用户id")
    private List<Long> toUserId;

}
