package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@ApiModel(description = "评论回复参数")
public class CommentReplyParam {
	@ApiModelProperty("上级评论id")
	private Long parentReplyId;

	@ApiModelProperty("新闻id")
	private Long newsId;

	@ApiModelProperty("评论内容")
	private String  replyContent;

	@ApiModelProperty("马甲号用户id")
	private Long virtualUserId;

	@ApiModelProperty("马甲号用户头像")
	private String virtualHeadImg;

	@ApiModelProperty("马甲号用户昵称")
	private String virtualNickName;

	@ApiModelProperty("评论回复时间")
	@DateTimeFormat(pattern= DateUtils.DATE_TIME_FORMAT)
	private Date replyTime;
}
