package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "商品分页查询参数")
public class CommodityQueryParam extends PageParam {

    @ApiModelProperty("商品ID，仅支持数字")
    private Long id;

    @ApiModelProperty("商品名称,模糊匹配")
    private String name;

    @ApiModelProperty("商家名称,模糊匹配")
    private String merchantName;

    @ApiModelProperty("商品类目，取值详见需求文档")
    private String type;

    @ApiModelProperty("商品状态，0：下架、1：上架")
    private Integer status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

}
