package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;

import java.util.Date;
import java.util.List;

@ApiModel(description = "新闻参数")
public class NewsReplyOriginalParam {
    /**
     * startTime :
     * endTime :
     * list : [{"content":"评论1"},{"content":"评论2"},{"content":"评论3"},{"content":"评论4"}]
     */
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date startTime;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date endTime;

    private List<Reply> list;

    private Long newsId;

    public Date getStartTime() {
        return startTime;
    }

    public NewsReplyOriginalParam setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getNewsId() {
        return newsId;
    }

    public NewsReplyOriginalParam setNewsId(Long newsId) {
        this.newsId = newsId;
        return this;
    }

    public Date getEndTime() {
        return endTime;
    }

    public NewsReplyOriginalParam setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<Reply> getList() {
        return list;
    }

    public void setList(List<Reply> list) {
        this.list = list;
    }

    public static class Reply {
        /**
         * content : 评论1
         */

        private String content;

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}
