package com.bxm.localnews.admin.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * C_AREA_INFO
 *
 * @author
 */
public class AreaInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 区域编码
     */
    private String code;

    /**
     * 区域名称
     */
    private String name;

    /**
     * 常住人口
     */
    private String population;

    /**
     * 地区描述（文案性质的描述），支持html
     */
    private String description;

    /**
     * 覆盖率
     */
    private String coverRate;

    /**
     * 传播率
     */
    private String transmissionRate;

    @ApiModelProperty(value = "是否启用VIP，1：启用，0：禁用", allowableValues = "0,1")
    private Byte enableVip = 0;

    @ApiModelProperty("是否启用推广赚钱")
    private Byte enablePaidPromote = 0;

    @ApiModelProperty(value = "是否启用社区内容，1：启用，0：禁用")
    private Integer enableCommunityContent;

    @ApiModelProperty(value = "是否启用首页发帖，1：启用，0：禁用")
    private Integer enableIndexPublish;

    @ApiModelProperty(value = "是否启用客服小助手，1：启用，0：禁用")
    private Integer enableCustomerService;

    @ApiModelProperty(value = "是否开启聊天室 1：启用，0：禁用")
    private Byte enableChatRoom;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPopulation() {
        return population;
    }

    public void setPopulation(String population) {
        this.population = population;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCoverRate() {
        return coverRate;
    }

    public void setCoverRate(String coverRate) {
        this.coverRate = coverRate;
    }

    public String getTransmissionRate() {
        return transmissionRate;
    }

    public void setTransmissionRate(String transmissionRate) {
        this.transmissionRate = transmissionRate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getEnableVip() {
        return enableVip;
    }

    public void setEnableVip(Byte enableVip) {
        this.enableVip = enableVip;
    }

    public Byte getEnablePaidPromote() {
        return enablePaidPromote;
    }

    public void setEnablePaidPromote(Byte enablePaidPromote) {
        this.enablePaidPromote = enablePaidPromote;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getEnableCommunityContent() {
        return enableCommunityContent;
    }

    public void setEnableCommunityContent(Integer enableCommunityContent) {
        this.enableCommunityContent = enableCommunityContent;
    }

    public Integer getEnableIndexPublish() {
        return enableIndexPublish;
    }

    public void setEnableIndexPublish(Integer enableIndexPublish) {
        this.enableIndexPublish = enableIndexPublish;
    }

    public Integer getEnableCustomerService() {
        return enableCustomerService;
    }

    public void setEnableCustomerService(Integer enableCustomerService) {
        this.enableCustomerService = enableCustomerService;
    }

    public Byte getEnableChatRoom() {
        return enableChatRoom;
    }

    public void setEnableChatRoom(Byte enableChatRoom) {
        this.enableChatRoom = enableChatRoom;
    }
}