package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "基础的监控条件参数")
@Data
public class BaseNewsMonitorConditionBean extends BaseBean {

    @ApiModelProperty("监控条件ID")
    private Long id;

    @ApiModelProperty("监控条件名称")
    private String name;

    @ApiModelProperty("是否全国投放，1：表示全国投放，0：区域投放")
    private byte globalFlag;

    @ApiModelProperty(required = true, value = "监控类型，NUM:数量")
    private String monitorType;

    @ApiModelProperty("新闻类目，全国投放时才有此参数")
    private int kindId;

    @ApiModelProperty(value = "监控条件包含的指标信息", required = true)
    private List<NewsMonitorIndexBean> monitorIndexList;
}
