package com.bxm.localnews.admin.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("渠道信息")
public class Channel {

    public static final String TYPE_1 = "10";//10 推广渠道

    public static final String TYPE_2 = "20";//20 应用市场

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("类型")
    private Integer mobileType;

    @ApiModelProperty("渠道编码")
    private String code;

    @ApiModelProperty("渠道名称")
    private String name;

    @ApiModelProperty("联系人")
    private String linker;

    @ApiModelProperty("联系电话")
    private String phone;

    @ApiModelProperty("推广渠道 10：推广渠道，20：应用市场")
    private Byte type;

    @ApiModelProperty("状态：10：禁用，20启用，此字段暂未使用")
    private Byte state;

    @ApiModelProperty("添加时间")
    private Date createTime;

    public Channel() {
    }

    public Channel(String code, String name, String linker, String phone, Date createTime) {
        this.code = code;
        this.name = name;
        this.linker = linker;
        this.phone = phone;
        this.createTime = createTime;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getMobileType() {
        return mobileType;
    }

    public void setMobileType(Integer mobileType) {
        this.mobileType = mobileType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getLinker() {
        return this.linker;
    }

    public void setLinker(String linker) {
        this.linker = linker == null ? null : linker.trim();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

}