package com.bxm.localnews.admin.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "商品信息实体")
public class CommodityBean extends BaseCommodityBean {

    @ApiModelProperty("所属商户名称")
    private String merchantName;

    @ApiModelProperty(value = "商品创建时间", hidden = true)
    @JsonIgnore
    private Date addTime;

    @ApiModelProperty(value = "商品创建人ID", hidden = true)
    @JsonIgnore
    private long creatorId;

    @ApiModelProperty(value = "删除标记，0表示未删除，1表示已删除", hidden = true)
    @JsonIgnore
    private int deleteFlag = 0;

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public int getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(int deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

}
