package com.bxm.localnews.admin.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("问题反馈")
public class Feedback {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("联系人")
    private String contact;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("状态，0未处理，1已处理")
    private int status;

    @ApiModelProperty("回复内容")
    private String replyContent;

    @ApiModelProperty("回复状态，0未回复，1已回复")
    private Boolean reply;

    @ApiModelProperty("回复时间")
    private Date replyTime;

    @ApiModelProperty("回复用户id")
    private Long replyUserId;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    public Feedback() {
    }

    public Feedback(Long userId, String content) {
        this.userId = userId;
        this.content = content;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact == null ? null : contact.trim();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Boolean getReply() {
        return this.reply;
    }

    public void setReply(Boolean reply) {
        this.reply = reply;
    }

    public Date getReplyTime() {
        return this.replyTime;
    }

    public void setReplyTime(Date replyTime) {
        this.replyTime = replyTime;
    }

    public Long getReplyUserId() {
        return this.replyUserId;
    }

    public void setReplyUserId(Long replyUserId) {
        this.replyUserId = replyUserId;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}
