package com.bxm.localnews.admin.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 17:32
 * @desc
 */
@ApiModel(description = "用户邀请记录")
public class InviteRecord extends BaseBean implements IUserIdSharding {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("发起邀请人id")
    private Long userId;

    @ApiModelProperty("被邀请人id")
    private Long invitedUserId;

    @ApiModelProperty("唯一编码")
    private String uniqueCode;

    @ApiModelProperty("被邀请人名称")
    private String invitedUserName;

    @ApiModelProperty("被邀请人头像")
    private String invitedUserImg;

    @ApiModelProperty("邀请途径：NEWS、ACTIVITY、MERCHANT、APPLET、VIP")
    private String type;

    @ApiModelProperty("奖励数量")
    private BigDecimal award = BigDecimal.ZERO;

    @ApiModelProperty("奖励类型")
    private String awardType;

    @ApiModelProperty("邀请类型: ACCEPT_INVITE、LOGIN_APP、SUCCESS_WITHDRAW、OVERDUE_INVALID、NOT_NEW_USER")
    private String inviteState;

    @ApiModelProperty("失效时间")
    private Date effectTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("变更时间")
    private Date modifyTime;

    @ApiModelProperty("邀请状态")
    private Byte status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getInvitedUserId() {
        return invitedUserId;
    }

    public void setInvitedUserId(Long invitedUserId) {
        this.invitedUserId = invitedUserId;
    }

    public String getUniqueCode() {
        return uniqueCode;
    }

    public void setUniqueCode(String uniqueCode) {
        this.uniqueCode = uniqueCode;
    }

    public String getInvitedUserName() {
        return invitedUserName;
    }

    public void setInvitedUserName(String invitedUserName) {
        this.invitedUserName = invitedUserName;
    }

    public String getInvitedUserImg() {
        return invitedUserImg;
    }

    public void setInvitedUserImg(String invitedUserImg) {
        this.invitedUserImg = invitedUserImg;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public BigDecimal getAward() {
        return award;
    }

    public void setAward(BigDecimal award) {
        this.award = award;
    }


    public String getAwardType() {
        return awardType;
    }

    public void setAwardType(String awardType) {
        this.awardType = awardType;
    }

    public String getInviteState() {
        return inviteState;
    }

    public void setInviteState(String inviteState) {
        this.inviteState = inviteState;
    }

    public Date getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }
}
