package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(description = "积分商城订单")
public class MarketOrder extends MarketOrderExpressage implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("发起订单的用户ID")
    private Long userId;

    @ApiModelProperty("订单所属用户名称")
    private String userName;

    @ApiModelProperty("订单所属平台ID（预留字段）")
    private Long platformId;

    @ApiModelProperty("商品ID")
    private Long commodityId;

    @ApiModelProperty("商品名称(生成订单时的名称)")
    private String commodityTitle;

    @ApiModelProperty("商品兑换价格（生成订单时的价格）")
    private BigDecimal commodityPrice;

    @ApiModelProperty("商品类型（VIRTUAL:虚拟商品，GOODS：实物），枚举定义，后续可扩展")
    private String commodityType;

    @ApiModelProperty("状态：0-已完成 1-失败 2-处理中")
    private Integer status;

    @ApiModelProperty("收货地址ID")
    private Long addressId;

    @ApiModelProperty("完整收货地址（与地址表同步）")
    private String finalAddress;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date createTime;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getPlatformId() {
        return platformId;
    }

    public void setPlatformId(Long platformId) {
        this.platformId = platformId;
    }

    public Long getCommodityId() {
        return commodityId;
    }

    public void setCommodityId(Long commodityId) {
        this.commodityId = commodityId;
    }

    public String getCommodityTitle() {
        return commodityTitle;
    }

    public void setCommodityTitle(String commodityTitle) {
        this.commodityTitle = commodityTitle;
    }

    public BigDecimal getCommodityPrice() {
        return commodityPrice;
    }

    public void setCommodityPrice(BigDecimal commodityPrice) {
        this.commodityPrice = commodityPrice;
    }

    public String getCommodityType() {
        return commodityType;
    }

    public void setCommodityType(String commodityType) {
        this.commodityType = commodityType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public String getFinalAddress() {
        return finalAddress;
    }

    public void setFinalAddress(String finalAddress) {
        this.finalAddress = finalAddress;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

}