package com.bxm.localnews.admin.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "商户信息实体")
public class MerchantBean extends BaseMerchantBean {

    @ApiModelProperty(value = "商户联系地址，由区县编码获取对应名+详细地址构成", hidden = true)
    @JsonIgnore
    private String displayAddress;

    @ApiModelProperty(value = "删除标记，0表示未删除，1表示已删除", hidden = true)
    @JsonIgnore
    private int deleteFlag = 0;

    @ApiModelProperty(value = "添加时间", hidden = true)
    @JsonIgnore
    private Date addTime;

    @ApiModelProperty(value = "商户信息来源", hidden = true)
    @JsonIgnore
    private String sourceType;

    @ApiModelProperty(value = "商户所属街区名称", hidden = true)
    @JsonIgnore
    private String townName;

    @ApiModelProperty("商户详细地址，用于列表显示")
    private String lastLevelAddress;

    public String getLastLevelAddress() {
        return lastLevelAddress;
    }

    public void setLastLevelAddress(String lastLevelAddress) {
        this.lastLevelAddress = lastLevelAddress;
    }

    public String getTownName() {
        return townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getDisplayAddress() {
        return displayAddress;
    }

    public void setDisplayAddress(String displayAddress) {
        this.displayAddress = displayAddress;
    }

    public int getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(int deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

}
