package com.bxm.localnews.admin.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(description = "活动信息实体")
public class PrivilegeBean extends BasePrivilegeBean {

    @ApiModelProperty(value = "删除标记", hidden = true)
    @JsonIgnore
    private int deleteFlag = 0;

    @ApiModelProperty("商品名称")
    private String commodityName;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty(value = "添加时间", hidden = true)
    @JsonIgnore
    private Date addTime;

    @ApiModelProperty("邀请人员总数")
    private int participantCount;

    @ApiModelProperty(value = "创建人ID", hidden = true)
    @JsonIgnore
    private long creatorId;

    @ApiModelProperty("投放区域列表，编辑时特有参数")
    private List<PrivilegeAreaBean> privilegeAreas;

    @ApiModelProperty("活动对应商品价格")
    private BigDecimal originalCost;

    @ApiModelProperty("生成二维码用的短链")
    private String shortUrl4QRCode;

    @ApiModelProperty("生成线下海报用的短链")
    private String shortUrl4Poster;

    public String getShortUrl4Poster() {
        return shortUrl4Poster;
    }

    public void setShortUrl4Poster(String shortUrl4Poster) {
        this.shortUrl4Poster = shortUrl4Poster;
    }

    public String getShortUrl4QRCode() {
        return shortUrl4QRCode;
    }

    public void setShortUrl4QRCode(String shortUrl4QRCode) {
        this.shortUrl4QRCode = shortUrl4QRCode;
    }

    public Long getOriginalCost() {
        return originalCost.longValue();
    }

    public void setOriginalCost(BigDecimal originalCost) {
        this.originalCost = originalCost;
    }

    public List<PrivilegeAreaBean> getPrivilegeAreas() {
        return privilegeAreas;
    }

    public void setPrivilegeAreas(List<PrivilegeAreaBean> privilegeAreas) {
        this.privilegeAreas = privilegeAreas;
    }

    public int getParticipantCount() {
        return participantCount;
    }

    public void setParticipantCount(int participantCount) {
        this.participantCount = participantCount;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(long creatorId) {
        this.creatorId = creatorId;
    }

    public int getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(int deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public String getCommodityName() {
        return commodityName;
    }

    public void setCommodityName(String commodityName) {
        this.commodityName = commodityName;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

}
