package com.bxm.localnews.admin.vo;

import com.github.pagehelper.Page;

/**
 * 分页Model
 * @author xx
 * @version 2.0
 * @since 2014年1月28日
 */
public class RdPage extends PageModel {

    /**
     * 默认分页起始页面，第一页
     */
    public static final int PAGE_NUM_DEFAULT = 1;

    /**
     * 默认分页条数，10条
     */
    public static final int PAGE_SIZE_DEFAULT = 10;

    /**
     * 总数
     */
    private long itemTotal;

    /**
     * 当前页数，从1开始
     */
    private int curPage;

    /**
     * 每页条数
     */
    private int pageSize;

    public RdPage() {
        super();
    }

    /**
     * 将pagehelper.page 赋值给 pages
     * @param page
     */
    public RdPage(Page<?> page) {
        this.itemTotal = page.getTotal();
        this.curPage = page.getPageNum();
        this.pageSize = page.getPageSize();
    }

    public long getItemTotal() {
        return this.itemTotal;
    }

    public void setItemTotal(long itemTotal) {
        this.itemTotal = itemTotal;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public void setCurPage(int curPage) {
        this.curPage = curPage;
    }

    /**
     * 获取每页条数
     * @return pageSize
     */
    public int getPageSize() {
        return this.pageSize == 0 ? PAGE_SIZE_DEFAULT : this.pageSize;
    }

    /**
     * 设置每页条数
     * @param pageSize
     */
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

}

