package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

@ApiModel(description = "话题")
public class Topic {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("图片")
    private String img;

    @ApiModelProperty("排序权重")
    private Integer order;

    @ApiModelProperty("是否启用：0禁用 1启用")
    private Byte enable;

    @ApiModelProperty("是否投放全国：0否 1是")
    private Byte isGlobal;

    @ApiModelProperty("地区编码数组")
    private List<String> areaCodes;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("地区数组")
    private List<Location> areas;

    @ApiModelProperty("引导发帖文案")
    private String leadPostContent;

    @ApiModelProperty("头条/本地圈推荐语")
    private String recommendContent;

    @ApiModelProperty("参与者代号")
    private String joinCode;

    @ApiModelProperty("内容")
    private String content;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    public Byte getIsGlobal() {
        return isGlobal;
    }

    public void setIsGlobal(Byte isGlobal) {
        this.isGlobal = isGlobal;
    }

    public List<String> getAreaCodes() {
        return areaCodes;
    }

    public void setAreaCodes(List<String> areaCodes) {
        this.areaCodes = areaCodes;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<Location> getAreas() {
        return areas;
    }

    public void setAreas(List<Location> areas) {
        this.areas = areas;
    }

    public String getLeadPostContent() {
        return leadPostContent;
    }

    public void setLeadPostContent(String leadPostContent) {
        this.leadPostContent = leadPostContent;
    }

    public String getRecommendContent() {
        return recommendContent;
    }

    public void setRecommendContent(String recommendContent) {
        this.recommendContent = recommendContent;
    }

    public String getJoinCode() {
        return joinCode;
    }

    public void setJoinCode(String joinCode) {
        this.joinCode = joinCode;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
