package com.bxm.localnews.admin.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/4 17:05
 * @desc
 */
@ApiModel(description = "用户账户信息")
public class UserAccount extends BaseBean implements IUserIdSharding {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("账号状态")
    private Byte state;

    @ApiModelProperty("可用金币余额")
    private Integer usableGold;

    @ApiModelProperty("临时金币余额")
    private Integer tempGold;

    @ApiModelProperty("金币总数")
    private Integer totalGold;

    @ApiModelProperty("消费金币总数")
    private Integer consumeGold;

    @ApiModelProperty("可提现金额")
    private BigDecimal drawablelCash;

    @ApiModelProperty("累计现金收入")
    private BigDecimal totalCash;

    @ApiModelProperty("固化现金收入")
    private BigDecimal tempCash;

    @ApiModelProperty("可用金币余额")
    private BigDecimal stabilizeCash;

    @ApiModelProperty("已提现总金额")
    private BigDecimal withdrawalCash;

    @ApiModelProperty("最后变更时间")
    private Date modifyTime;

    @ApiModelProperty("账号创建时间")
    private Date createTime;

    public UserAccount() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Integer getUsableGold() {
        return usableGold;
    }

    public void setUsableGold(Integer usableGold) {
        this.usableGold = usableGold;
    }

    public Integer getTempGold() {
        return tempGold;
    }

    public void setTempGold(Integer tempGold) {
        this.tempGold = tempGold;
    }

    public Integer getTotalGold() {
        return totalGold;
    }

    public void setTotalGold(Integer totalGold) {
        this.totalGold = totalGold;
    }

    public Integer getConsumeGold() {
        return consumeGold;
    }

    public void setConsumeGold(Integer consumeGold) {
        this.consumeGold = consumeGold;
    }

    public BigDecimal getDrawablelCash() {
        return drawablelCash;
    }

    public void setDrawablelCash(BigDecimal drawablelCash) {
        this.drawablelCash = drawablelCash;
    }

    public BigDecimal getTotalCash() {
        return totalCash;
    }

    public void setTotalCash(BigDecimal totalCash) {
        this.totalCash = totalCash;
    }

    public BigDecimal getTempCash() {
        return tempCash;
    }

    public void setTempCash(BigDecimal tempCash) {
        this.tempCash = tempCash;
    }

    public BigDecimal getStabilizeCash() {
        return stabilizeCash;
    }

    public void setStabilizeCash(BigDecimal stabilizeCash) {
        this.stabilizeCash = stabilizeCash;
    }

    public BigDecimal getWithdrawalCash() {
        return withdrawalCash;
    }

    public void setWithdrawalCash(BigDecimal withdrawalCash) {
        this.withdrawalCash = withdrawalCash;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
