package com.bxm.localnews.admin.vo.im;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Gonzo
 * @date 2019-11-01 11:46
 */
@Data
@ApiModel(description = "聊天室定时红包计划")
@Builder
public class ImTimingRedPacketPlanVO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("红包名称")
    private String redPacketName;

    @ApiModelProperty("聊天室id")
    private String chatRoomId;

    @ApiModelProperty("每日定时发送的时间 eg: 12:00")
    private String sentTimeStr;

    @ApiModelProperty("红包金额 单位元")
    private BigDecimal redPacketTotalAmount;

    @ApiModelProperty("红包总可领取数")
    private Integer redPacketTotalNum;

    @ApiModelProperty("状态：1：正常")
    private Byte status;

    @ApiModelProperty("最后修改时间")
    private Date modifyTime;

    @ApiModelProperty("创建时间")
    private Date createTime;
}
