/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.config;

import com.bxm.localnews.admin.config.AuthorizationProperties;
import com.bxm.localnews.admin.config.CustomAccessDeniedHandler;
import com.bxm.localnews.admin.config.jwt.JwtAuthenticationEntryPoint;
import com.bxm.localnews.admin.config.jwt.JwtAuthenticationTokenFilter;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private AuthorizationProperties authorizationProperties;
    private HttpSecurity httpSecurity;

    @Autowired
    public void configureAuthentication(AuthenticationManagerBuilder authenticationManagerBuilder) throws Exception {
        authenticationManagerBuilder.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder);
    }

    public void configure(WebSecurity web) throws Exception {
        SecurityExpressionHandler handler = web.getExpressionHandler();
        AuthenticationManager authenticationManager = this.authenticationManager();
        web.postBuildAction(() -> {
            FilterSecurityInterceptor interceptor = (FilterSecurityInterceptor)this.httpSecurity.getSharedObject(FilterSecurityInterceptor.class);
            interceptor.setAuthenticationManager(authenticationManager);
        });
    }

    @Bean
    public JwtAuthenticationEntryPoint authenticationEntryPoint() {
        return new JwtAuthenticationEntryPoint("/api/admin/toLoginNew");
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler()).authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(new String[]{"/druid/**"})).permitAll().antMatchers(new String[]{"/auth/**"})).permitAll().antMatchers(new String[]{"/v2/api-docs"})).permitAll().antMatchers(new String[]{"/swagger-ui.html"})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/swagger/**"})).permitAll().antMatchers(new String[]{"/app/**"})).permitAll().antMatchers(new String[]{"/swagger-resources/**"})).permitAll().antMatchers(new String[]{"/api/admin/toLoginNew"})).permitAll().antMatchers(new String[]{"/api/admin/vcode"})).permitAll().antMatchers(new String[]{"/api/admin/logout"})).permitAll().anyRequest()).authenticated();
        if (!this.authorizationProperties.getRoleUrl().isEmpty()) {
            for (Map.Entry<String, String> entry : this.authorizationProperties.getRoleUrl().entrySet()) {
                if (entry.getValue().contains(",")) {
                    String[] str;
                    for (String s : str = StringUtils.split((String)entry.getValue(), (String)",")) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{entry.getKey()})).hasRole(s);
                    }
                    continue;
                }
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{entry.getKey()})).hasRole(entry.getValue());
            }
        }
        http.addFilterBefore((Filter)this.authenticationTokenFilterBean(), UsernamePasswordAuthenticationFilter.class);
        http.headers().cacheControl();
        this.httpSecurity = http;
    }

    @Bean
    public AuthorizationProperties getAuthorizationProperties() {
        return new AuthorizationProperties();
    }

    @Bean
    public JwtAuthenticationTokenFilter authenticationTokenFilterBean() {
        return new JwtAuthenticationTokenFilter();
    }

    @Bean
    public CustomAccessDeniedHandler accessDeniedHandler() {
        return new CustomAccessDeniedHandler();
    }

    @Bean
    public AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }
}

