/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.config.jwt;

import com.bxm.localnews.admin.constant.SecurityConstant;
import com.bxm.localnews.admin.service.JwtTokenService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private JwtTokenService jwtTokenService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        UserDetails userDetails;
        String account;
        String authToken = request.getHeader(SecurityConstant.HEAD_KEY);
        if (StringUtils.isNotBlank((CharSequence)authToken) && (account = this.jwtTokenService.getUsernameFromToken(authToken)) != null && SecurityContextHolder.getContext().getAuthentication() == null && this.jwtTokenService.validateToken(authToken, userDetails = this.userDetailsService.loadUserByUsername(account)).booleanValue()) {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            String newToken = this.jwtTokenService.renewToken(authToken);
            if (null != newToken) {
                response.addHeader("RenewToken", newToken);
                response.addHeader("Access-Control-Expose-Headers", "RenewToken");
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

