/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.config.jwt;

import com.bxm.localnews.admin.service.AdminRoleService;
import com.bxm.localnews.admin.service.AdminUserService;
import com.bxm.localnews.admin.vo.AdminUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class JwtUserDetailsServiceImpl
implements UserDetailsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private AdminUserService adminUserService;
    private AdminRoleService adminRoleService;

    @Autowired
    public JwtUserDetailsServiceImpl(AdminUserService adminUserService, AdminRoleService adminRoleService) {
        this.adminUserService = adminUserService;
        this.adminRoleService = adminRoleService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new UsernameNotFoundException("\u7528\u6237\u8d26\u6237\u4e3a\u7a7a");
        }
        AdminUser userInfo = this.adminUserService.getCacheUser(username);
        if (null == userInfo) {
            throw new UsernameNotFoundException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        userInfo.setAuthorities(this.adminRoleService.getUserAuthorities(userInfo.getId()));
        return userInfo;
    }
}

