/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service;

import com.bxm.localnews.admin.config.SecurityConfigurationProperties;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.newidea.component.tools.DateUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenService
implements Serializable {
    private static final long serialVersionUID = -3301605591108950415L;
    private static final String CLAIM_KEY_USERNAME = "sub";
    private static final String CLAIM_KEY_CREATED = "created";
    private final SecurityConfigurationProperties properties;

    @Autowired
    public JwtTokenService(SecurityConfigurationProperties properties) {
        this.properties = properties;
    }

    public String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = this.getClaimsFromToken(token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    private Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = this.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)CLAIM_KEY_CREATED));
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    protected Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = this.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    private Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(this.properties.getJwtSecret()).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + this.properties.getJwtTokenExpiration() * 1000L);
    }

    private Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    private Boolean isCreatedAfterChangeDate(Date created, Date changeDate) {
        return changeDate != null && created.after(changeDate);
    }

    public String generateToken(AdminUser userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(CLAIM_KEY_USERNAME, userDetails.getUsername());
        claims.put(CLAIM_KEY_CREATED, new Date());
        return this.generateToken(claims);
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, this.properties.getJwtSecret()).compact();
    }

    public Boolean canTokenBeRefreshed(String token, Date lastReset) {
        Date created = this.getCreatedDateFromToken(token);
        return this.isCreatedAfterChangeDate(created, lastReset);
    }

    public String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = this.getClaimsFromToken(token);
            claims.put((Object)CLAIM_KEY_CREATED, (Object)new Date());
            refreshedToken = this.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public String renewToken(String token) {
        Date expirationDate = this.getExpirationDateFromToken(token);
        long diffSeconeds = DateUtils.getDiffSeconed((Date)expirationDate, (Date)new Date(), (boolean)false);
        if (diffSeconeds <= this.properties.getJwtTokenRenew()) {
            return this.refreshToken(token);
        }
        return null;
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        AdminUser user = (AdminUser)userDetails;
        String username = this.getUsernameFromToken(token);
        Date created = this.getCreatedDateFromToken(token);
        return username.equals(user.getUsername()) && this.isCreatedAfterChangeDate(created, user.getResetTime()) != false;
    }
}

