/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AdminAdvertAreaMapper;
import com.bxm.localnews.admin.domain.AdminAdvertMapper;
import com.bxm.localnews.admin.dto.AdvertDTO;
import com.bxm.localnews.admin.param.AdvertParam;
import com.bxm.localnews.admin.service.AdminAdvertService;
import com.bxm.localnews.admin.vo.Advert;
import com.bxm.localnews.admin.vo.AdvertArea;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminAdvertServiceImpl
implements AdminAdvertService {
    private AdminAdvertMapper adminAdvertMapper;
    private AdminAdvertAreaMapper adminAdvertAreaMapper;
    private SequenceCreater sequenceCreater;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public AdminAdvertServiceImpl(AdminAdvertMapper adminAdvertMapper, AdminAdvertAreaMapper adminAdvertAreaMapper, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter) {
        this.adminAdvertMapper = adminAdvertMapper;
        this.adminAdvertAreaMapper = adminAdvertAreaMapper;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public PageWarper<AdvertDTO> getAdvertList(AdvertParam advertParam) {
        PageWarper pageWarper = new PageWarper(this.adminAdvertMapper.queryAdverts(advertParam));
        pageWarper.getList().forEach(advertDTO -> {
            if (advertDTO.getGlobalFlag() != null && advertDTO.getGlobalFlag() == 0) {
                advertDTO.setAreaList(this.adminAdvertAreaMapper.getAdvertAreaDTOByadvertId(advertDTO.getId()));
            }
        });
        return pageWarper;
    }

    @Override
    public AdvertDTO getAdvertById(Long id) {
        Advert advert = this.adminAdvertMapper.selectByPrimaryKey(id);
        return this.convertAdvert(advert);
    }

    @Override
    public int updateAdvertStatusById(String[] ids, Byte status) {
        return this.adminAdvertMapper.updateAdvertStatusById(ids, status);
    }

    @Override
    public int updateAdvertStatusById(Long id, Byte status) {
        Advert advert = this.adminAdvertMapper.selectByPrimaryKey(id);
        if (advert != null) {
            advert.setStatus(status);
            if (StringUtils.isNotBlank((CharSequence)advert.getType())) {
                this.redisStringAdapter.remove(this.getAdvertListKey(Byte.valueOf(advert.getType())));
            }
        }
        return this.adminAdvertMapper.updateByPrimaryKeySelective(advert);
    }

    @Override
    public int addAdvertDetail(Advert advert, String areaCodes) {
        int update;
        Long advertId = advert.getId();
        if (advertId == null) {
            advertId = this.sequenceCreater.nextLongId();
        }
        this.updateAdvertArea(areaCodes, advertId);
        if (advert.getId() == null) {
            advert.setId(advertId);
            advert.setAddTime(new Date());
            update = this.adminAdvertMapper.insertSelective(advert);
        } else {
            update = this.adminAdvertMapper.updateByPrimaryKeySelective(advert);
        }
        if (StringUtils.isNotBlank((CharSequence)advert.getType())) {
            this.redisStringAdapter.remove(this.getAdvertListKey(Byte.valueOf(advert.getType())));
        }
        return update;
    }

    @Override
    public int deleteAdvert(Long id) {
        Advert advert = this.adminAdvertMapper.selectByPrimaryKey(id);
        if (StringUtils.isNotBlank((CharSequence)advert.getType())) {
            this.redisStringAdapter.remove(this.getAdvertListKey(Byte.valueOf(advert.getType())));
        }
        return this.adminAdvertMapper.deleteByPrimaryKey(advert.getId());
    }

    private void updateAdvertArea(String areaCodes, Long advertId) {
        if (StringUtils.isBlank((CharSequence)areaCodes)) {
            return;
        }
        this.adminAdvertAreaMapper.deleteByAdvertId(advertId);
        this.insertAdvertArea(areaCodes, advertId);
    }

    private void insertAdvertArea(String areaCodes, Long advertId) {
        String[] areaCode = StringUtils.split((String)areaCodes, (String)",");
        ArrayList<AdvertArea> advertAreaList = new ArrayList<AdvertArea>(areaCode.length);
        for (String s : areaCode) {
            AdvertArea advertArea = new AdvertArea();
            advertArea.setAdvertId(advertId);
            advertArea.setCode(s);
            advertArea.setId(this.sequenceCreater.nextLongId());
            advertAreaList.add(advertArea);
        }
        this.adminAdvertAreaMapper.insertAdvertAreas(advertAreaList);
    }

    private KeyGenerator getAdvertListKey(Byte type) {
        return RedisConfig.THIRDPARTY_TYPE_ADVERT.copy().appendKey((Object)type).appendKey((Object)"list");
    }

    private KeyGenerator getAllAdvertListKey() {
        return RedisConfig.THIRDPARTY_TYPE_ADVERT.copy().appendKey((Object)"*").appendKey((Object)"list");
    }

    private AdvertDTO convertAdvert(Advert advert) {
        AdvertDTO advertDTO = new AdvertDTO();
        BeanUtils.copyProperties((Object)advert, (Object)advertDTO);
        if (advert.getGlobalFlag() == 0) {
            advertDTO.setAreaList(this.adminAdvertAreaMapper.getAdvertAreaDTOByadvertId(advert.getId()));
        }
        return advertDTO;
    }
}

