/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminMessageMapper;
import com.bxm.localnews.admin.param.MessageParam;
import com.bxm.localnews.admin.service.AdminMessageService;
import com.bxm.localnews.admin.vo.Message;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.SendStateEunm;
import com.bxm.localnews.mq.common.constant.SendTypeEunm;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AdminMessageServiceImpl
implements AdminMessageService {
    @Resource
    private AdminMessageMapper adminMessageMapper;

    @Override
    public Message selectByPrimaryKey(Long id) {
        Message messageInfo = this.adminMessageMapper.selectByPrimaryKey(Integer.valueOf(id.intValue()));
        if (null != messageInfo) {
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(messageInfo.getSendType()))) {
                messageInfo.setSendTypeStr(SendTypeEunm.getSendByType((String)String.valueOf(messageInfo.getSendType())));
            }
            if (!StringUtils.isEmpty((CharSequence)String.valueOf(messageInfo.getSendState()))) {
                messageInfo.setSendStateStr(SendStateEunm.getSendByState((String)String.valueOf(messageInfo.getSendState())));
            }
            if (!StringUtils.isEmpty((CharSequence)messageInfo.getSendTime())) {
                messageInfo.setSendTime(messageInfo.getSendTime().substring(0, messageInfo.getSendTime().indexOf(".")));
            }
        }
        return messageInfo;
    }

    @Override
    public int insertSelective(Message record) {
        return this.adminMessageMapper.insertSelective(record);
    }

    @Override
    public PageWarper<Message> queryMessages(MessageParam messageParam) {
        Preconditions.checkArgument((messageParam != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.adminMessageMapper.selectAdminMsgList(messageParam));
        for (Message message : pageWarper.getList()) {
            message.setTypeStr(PushMessageEnum.getMessageDescByType((String)message.getMsgType()));
            message.setSendTypeStr(SendTypeEunm.getSendByType((String)String.valueOf(message.getSendType())));
            message.setSendStateStr(SendStateEunm.getSendByState((String)String.valueOf(message.getSendState())));
            if (StringUtils.isEmpty((CharSequence)message.getSendTime())) continue;
            message.setSendTime(message.getSendTime().substring(0, message.getSendTime().indexOf(".")));
        }
        return pageWarper;
    }

    @Override
    public int updateByPrimaryKeySelective(Message record) {
        return this.adminMessageMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.adminMessageMapper.deleteByPrimaryKey(Integer.valueOf(id.intValue()));
    }
}

