/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.domain.AdminNewsInformMapper;
import com.bxm.localnews.admin.param.NewsInformParam;
import com.bxm.localnews.admin.service.AdminNewsInformService;
import com.bxm.localnews.admin.vo.NewsInform;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminNewsInformServiceImpl
implements AdminNewsInformService {
    private AdminNewsInformMapper adminNewsInformMapper;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AdminNewsInformServiceImpl(AdminNewsInformMapper adminNewsInformMapper, BizConfigProperties bizConfigProperties) {
        this.adminNewsInformMapper = adminNewsInformMapper;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public PageWarper<NewsInform> queryNewsInforms(NewsInformParam newsInformParam) {
        Preconditions.checkArgument((newsInformParam != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.adminNewsInformMapper.queryNewsInformByPageSize(newsInformParam));
        List newsInformList = pageWarper.getList();
        String serverHost = this.bizConfigProperties.getServerHost();
        for (NewsInform NewsInform2 : newsInformList) {
            NewsInform2.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + NewsInform2.getNewsId() + "&userId=&type=1");
        }
        return pageWarper;
    }

    @Override
    public int updateByMap(Map<String, Object> map) {
        return this.adminNewsInformMapper.updateByMap(map);
    }
}

