/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.domain.AdminNewsMapper;
import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.service.AdminNewsService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminNewsServiceImpl
implements AdminNewsService {
    private AdminNewsMapper adminNewsMapper;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public AdminNewsServiceImpl(AdminNewsMapper adminNewsMapper, BizConfigProperties bizConfigProperties) {
        this.adminNewsMapper = adminNewsMapper;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public PageWarper<News> queryNews(NewsParam newsParam) {
        PageWarper pageWarper = new PageWarper(this.adminNewsMapper.queryNewsByPageSize(newsParam));
        List newsList = pageWarper.getList();
        String serverHost = this.bizConfigProperties.getServerHost();
        for (News news : newsList) {
            if (news.getType() != 1 && news.getType() != 3) continue;
            news.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=&type=" + news.getType());
        }
        return pageWarper;
    }

    @Override
    public int updateByPrimaryKeySelective(News news) {
        return this.adminNewsMapper.updateByPrimaryKeySelective(news);
    }

    @Override
    public int updateNewsStatusByIds(String[] ids, Byte status) {
        return this.adminNewsMapper.updateNewsStatusByIds(ids, status);
    }

    @Override
    public News selectByPrimaryKey(Long id) {
        News news = this.adminNewsMapper.selectByPrimaryKey(id);
        String serverHost = this.bizConfigProperties.getServerHost();
        if (news.getType() == 1 || news.getType() == 3) {
            news.setLinkUrl(serverHost + "/newsDetail.html?newsId=" + news.getId() + "&userId=&type=" + news.getType());
        }
        return news;
    }
}

