/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminRoleMapper;
import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.AdminRoleService;
import com.bxm.localnews.admin.vo.AdminRole;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.vo.PageWarper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class AdminRoleServiceImpl
implements AdminRoleService {
    private AdminRoleMapper adminRoleMapper;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AdminRoleServiceImpl(AdminRoleMapper adminRoleMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.adminRoleMapper = adminRoleMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public PageWarper<AdminRoleDTO> selectAll(RoleParam roleParam) {
        return new PageWarper(this.adminRoleMapper.selectAll(roleParam));
    }

    @Override
    public AdminRole selectByRoleCode(String roleCode) {
        return this.adminRoleMapper.selectByRoleCode(roleCode);
    }

    @Override
    public int insertSelective(AdminRole adminRole) {
        return this.adminRoleMapper.insertSelective(adminRole);
    }

    @Override
    public int updateByPrimaryKeySelective(AdminRole adminRole) {
        return this.adminRoleMapper.updateByPrimaryKeySelective(adminRole);
    }

    @Override
    public int deleteByPrimaryKey(Integer roleId) {
        return this.adminRoleMapper.deleteByPrimaryKey(roleId);
    }

    @Override
    public AdminRole selectByPrimaryKey(Integer roleId) {
        return this.adminRoleMapper.selectByPrimaryKey(roleId);
    }

    @Override
    public List<AdminRole> selectByUserId(Long id) {
        TypeReference<List<AdminRole>> typeReference = new TypeReference<List<AdminRole>>(){};
        List permissions = (List)this.redisHashMapAdapter.get(this.getRoleKey(), id.toString(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)permissions) && CollectionUtils.isNotEmpty((Collection)(permissions = this.adminRoleMapper.selectByUserId(id)))) {
            this.redisHashMapAdapter.put(this.getRoleKey(), id.toString(), (Object)permissions);
        }
        return permissions;
    }

    @Override
    public Collection<? extends GrantedAuthority> getUserAuthorities(Long userId) {
        List<AdminRole> permissions = this.selectByUserId(userId);
        Collection authorities = permissions.stream().map(permission -> new SimpleGrantedAuthority("ROLE_" + permission.getRoleCode())).collect(Collectors.toList());
        return authorities;
    }

    private KeyGenerator getRoleKey() {
        return DefaultKeyGenerator.build((String)"admin", (String)"role", (String)"user");
    }
}

