/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminUserMapper;
import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.service.AdminRoleService;
import com.bxm.localnews.admin.service.AdminUserService;
import com.bxm.localnews.admin.service.JwtTokenService;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminUserServiceImpl
implements AdminUserService {
    private RedisStringAdapter redisStringAdapter;
    private AdminUserMapper adminUserMapper;
    private JwtTokenService jwtTokenService;
    private AdminRoleService adminRoleService;

    @Autowired
    public AdminUserServiceImpl(RedisStringAdapter redisStringAdapter, AdminUserMapper adminUserMapper, JwtTokenService jwtTokenService, AdminRoleService adminRoleService) {
        this.redisStringAdapter = redisStringAdapter;
        this.adminUserMapper = adminUserMapper;
        this.jwtTokenService = jwtTokenService;
        this.adminRoleService = adminRoleService;
    }

    @Override
    public AdminUser getCacheUser(String userName) {
        KeyGenerator key = this.getCacheKey(userName);
        AdminUser user = (AdminUser)this.redisStringAdapter.get(key, AdminUser.class);
        if (null == user && null != (user = this.adminUserMapper.getByUserName(userName))) {
            user.setResetTime(new Date());
            this.redisStringAdapter.set(key, (Object)user);
        }
        return user;
    }

    @Override
    public void clearCacheUser(String userName) {
        KeyGenerator key = this.getCacheKey(userName);
        this.redisStringAdapter.remove(key);
    }

    @Override
    public AdminUser getUserByToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return new AdminUser();
        }
        String userName = this.jwtTokenService.getUsernameFromToken(token);
        return this.getCacheUser(userName);
    }

    @Override
    public Json modifyPassword(AdminUserDTO param) {
        String oldPassword = MD5Util.hgmd5((String)param.getOldPassword());
        String newPassword = MD5Util.hgmd5((String)param.getNewPassword());
        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());
        if (null == oldSysUser) {
            return ResultUtil.genFailedResult((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!oldSysUser.getPassword().equals(oldPassword)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u539f\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e");
        }
        if (oldSysUser.getPassword().equals(newPassword)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeCacheUser(param.getUsername());
        return ResultUtil.genSuccessMsg((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    @Override
    public Json modifyPasswordByAdmin(AdminUserDTO param) {
        String newPassword = MD5Util.hgmd5((String)param.getNewPassword());
        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());
        if (null == oldSysUser) {
            return ResultUtil.genFailedResult((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeCacheUser(param.getUsername());
        return ResultUtil.genSuccessMsg((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    private KeyGenerator getCacheKey(String userName) {
        return DefaultKeyGenerator.build((String)"admin", (String)"user", (String)userName);
    }

    @Override
    public Message removeCacheUser(String userName) {
        return Message.build((boolean)this.redisStringAdapter.remove(this.getCacheKey(userName)));
    }

    @Override
    public Boolean editUserPassWord(AdminUser sysUser) {
        return this.adminUserMapper.editUserPassWord(sysUser);
    }

    @Override
    public PageWarper<AdminUserDTO> queryAdminUsers(AdminUserParam adminUserParam) {
        Preconditions.checkArgument((adminUserParam != null ? 1 : 0) != 0);
        PageHelper.startPage((int)adminUserParam.getPageNum(), (int)adminUserParam.getPageSize());
        List list = this.adminUserMapper.queryAdminUser(adminUserParam);
        PageWarper pageWarper = new PageWarper(list);
        return pageWarper;
    }

    @Override
    public AdminUser selectByUsername(String username) {
        return this.adminUserMapper.selectByUsername(username);
    }

    @Override
    public int upsert(AdminUserDTO user) {
        String password = MD5Util.hgmd5((String)user.getPassword());
        user.setPassword(password);
        return this.adminUserMapper.upsert(user);
    }

    @Override
    public int updateByPrimaryKeySelective(AdminUser record) {
        String password = MD5Util.hgmd5((String)record.getPassword());
        record.setPassword(password);
        return this.adminUserMapper.updateByPrimaryKeySelective(record);
    }
}

