/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.domain.AreaInfoMapper;
import com.bxm.localnews.admin.dto.AreaInfoDTO;
import com.bxm.localnews.admin.param.AreaInfoParam;
import com.bxm.localnews.admin.service.AreaInfoService;
import com.bxm.localnews.admin.vo.AreaDivision;
import com.bxm.localnews.admin.vo.AreaInfo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaInfoServiceImpl
extends BaseService
implements AreaInfoService {
    @Autowired
    private AreaInfoMapper areaInfoMapper;
    @Autowired
    private AreaDivisionMapper areaDivisionMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public PageWarper<AreaInfo> queryPages(AreaInfoParam areaInfoParam) {
        PageWarper pageWarper = new PageWarper(this.areaInfoMapper.queryByPageSize(areaInfoParam));
        return pageWarper;
    }

    @Override
    public Message saveAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = this.areaInfoMapper.selectByCode(areaInfoParam.getCode());
        if (null != areaInfo) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        AreaInfo areaInfoEntity = this.convertAreaInfo(areaInfoParam);
        int count = this.areaInfoMapper.insertSelective(areaInfoEntity);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return Message.build((boolean)true);
    }

    private AreaInfo convertAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = new AreaInfo();
        areaInfo.setName(areaInfoParam.getName());
        areaInfo.setCode(areaInfoParam.getCode());
        areaInfo.setCoverRate(areaInfoParam.getCoverRate());
        areaInfo.setDescription(areaInfoParam.getDescription());
        areaInfo.setPopulation(areaInfoParam.getPopulation());
        areaInfo.setTransmissionRate(areaInfoParam.getTransmissionRate());
        areaInfo.setId(this.nextSequence());
        return areaInfo;
    }

    @Override
    public int updateAreaInfo(AreaInfoParam areaInfoParam) {
        AreaInfo areaInfo = new AreaInfo();
        areaInfo.setName(areaInfoParam.getName());
        areaInfo.setCode(areaInfoParam.getCode());
        areaInfo.setCoverRate(areaInfoParam.getCoverRate());
        areaInfo.setDescription(areaInfoParam.getDescription());
        areaInfo.setPopulation(areaInfoParam.getPopulation());
        areaInfo.setTransmissionRate(areaInfoParam.getTransmissionRate());
        areaInfo.setId(areaInfoParam.getId());
        int count = this.areaInfoMapper.updateByPrimaryKeySelective(areaInfo);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return count;
    }

    @Override
    public int delAreaInfo(String code) {
        int count = this.areaInfoMapper.deleteByCode(code);
        if (count == 1) {
            List areaInfoList = this.areaInfoMapper.queryByPageSize(null);
            this.redisStringAdapter.set(RedisConfig.AREA_INFO, (Object)areaInfoList);
        }
        return count;
    }

    @Override
    public AreaInfoDTO getAreaInfo(String code) {
        AreaDivision areaDivisionUp;
        AreaInfo areaInfo = this.areaInfoMapper.selectByCode(code);
        AreaDivision areaDivision = this.areaDivisionMapper.selectByCode(areaInfo.getCode());
        String parentCode = areaDivision.getParentCode();
        if (null != parentCode && null != (areaDivisionUp = this.areaDivisionMapper.selectByCode(parentCode)).getParentCode()) {
            parentCode = areaDivisionUp.getParentCode();
        }
        String parentName = this.areaDivisionMapper.selectByCode(parentCode).getName();
        AreaInfoDTO areaInfoDTO = new AreaInfoDTO();
        areaInfoDTO.setId(areaInfo.getId());
        areaInfoDTO.setProvinceCode(parentCode);
        areaInfoDTO.setName(areaInfo.getName());
        areaInfoDTO.setProvinceName(parentName);
        areaInfoDTO.setCode(areaInfo.getCode());
        areaInfoDTO.setCoverRate(areaInfo.getCoverRate());
        areaInfoDTO.setTransmissionRate(areaInfo.getTransmissionRate());
        areaInfoDTO.setPopulation(areaInfo.getPopulation());
        areaInfoDTO.setDescription(areaInfo.getDescription());
        return areaInfoDTO;
    }
}

