/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AreaDivisionMapper;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.param.LocationParam;
import com.bxm.localnews.admin.service.LocationService;
import com.bxm.localnews.admin.vo.AreaDivision;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.PinyinUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationServiceImpl
implements LocationService {
    @Autowired
    private LocationMapper locationMapper;
    @Autowired
    private AreaDivisionMapper areaDivisionMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public List<LocationDTO> listLocation(LocationParam locationParam) {
        Location location = new Location();
        BeanUtils.copyProperties((Object)locationParam, (Object)location);
        List locationList = this.locationMapper.selectByModel(location);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    @Override
    public void saveHotLocation(String code) {
        Location location = this.locationMapper.selectByCode(code);
        if (location.getHot().equals((byte)0)) {
            location.setHot(Byte.valueOf((byte)1));
            location.setShow(Byte.valueOf((byte)1));
            int count = this.locationMapper.updateByCodeSelective(location);
            if (count == 1) {
                List<LocationDTO> locationDTOList = this.listHotLocation();
                this.redisStringAdapter.set(RedisConfig.HOT_LOCATION, locationDTOList);
            }
        }
    }

    private List<LocationDTO> listHotLocation() {
        Location locationParam = new Location();
        locationParam.setHot(Byte.valueOf((byte)1));
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    private List<LocationDTO> listOpenedLocation() {
        Location locationParam = new Location();
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        locationDTOList.forEach(x -> x.setPinyin(PinyinUtils.getPinYinHeadChar((String)x.getName()).substring(0, 1).toUpperCase()));
        return locationDTOList;
    }

    @Override
    public void saveOpenedLocation(String code) {
        Location location = this.locationMapper.selectByCode(code);
        if (location.getShow().equals((byte)0)) {
            location.setShow(Byte.valueOf((byte)1));
            int count = this.locationMapper.updateByCodeSelective(location);
            if (count == 1) {
                List<LocationDTO> locationDTOList = this.listOpenedLocation();
                this.redisStringAdapter.set(RedisConfig.OPENED_LOCATION, locationDTOList);
            }
        }
    }

    @Override
    public List<LocationDTO> listOpenedLocationByArea(String code, Byte show) {
        ArrayList<Location> locationList = new ArrayList<Location>();
        Location location = this.locationMapper.selectByCode(code);
        List locationListByParent = this.locationMapper.selectByParentCode(code, show);
        if (null != location) {
            locationList.add(location);
        }
        if (CollectionUtils.isNotEmpty((Collection)locationListByParent)) {
            locationList.addAll(locationListByParent);
        }
        return locationList.stream().map(this::convertLocation).collect(Collectors.toList());
    }

    @Override
    public List<LocationDTO> listOpenedLocationByAreaWithTwoLevels(String code, Byte show) {
        ArrayList<LocationDTO> locationDTOList = new ArrayList<LocationDTO>();
        AreaDivision areaDivisionParam = new AreaDivision();
        areaDivisionParam.setParentCode(code);
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivisionParam);
        for (AreaDivision areaDivision : areaDivisionList) {
            List<LocationDTO> temLocationDTOList = this.listOpenedLocationByArea(areaDivision.getCode(), show);
            locationDTOList.addAll(temLocationDTOList);
        }
        return locationDTOList;
    }

    private LocationDTO convertLocation(Location location) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(location.getCode());
        locationDTO.setHot(location.getHot());
        locationDTO.setShow(location.getShow());
        locationDTO.setLevel(location.getLevel());
        locationDTO.setName(location.getName());
        locationDTO.setPinyin(location.getPinyin());
        return locationDTO;
    }

    private LocationDTO convertLocationByDivision(AreaDivision areaDivision) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(areaDivision.getCode());
        locationDTO.setLevel(areaDivision.getLevel());
        locationDTO.setName(areaDivision.getName());
        return locationDTO;
    }
}

