/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.constant.ApproveResultEnum;
import com.bxm.localnews.admin.constant.ApproveTypeEnum;
import com.bxm.localnews.admin.constant.SourceTypeEnum;
import com.bxm.localnews.admin.domain.MerchantMapper;
import com.bxm.localnews.admin.dto.AreaDivisionDetailDTO;
import com.bxm.localnews.admin.param.MerchantParam;
import com.bxm.localnews.admin.param.MerchantQueryParam;
import com.bxm.localnews.admin.service.ApproveHistoryService;
import com.bxm.localnews.admin.service.AreaDivisionService;
import com.bxm.localnews.admin.service.BaseAdminService;
import com.bxm.localnews.admin.service.MerchantService;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.vo.BaseMerchantBean;
import com.bxm.localnews.admin.vo.MerchantBean;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MerchantServiceImpl
extends BaseAdminService
implements MerchantService {
    private MerchantMapper merchantMapper;
    private GeoService geoService;
    private AreaDivisionService areaDivisionService;
    private ApproveHistoryService approveHistoryService;
    private PushMsgIntegService pushMsgIntegService;

    @Autowired
    public MerchantServiceImpl(MerchantMapper merchantMapper, GeoService geoService, AreaDivisionService areaDivisionService, ApproveHistoryService approveHistoryService, PushMsgIntegService pushMsgIntegService) {
        this.merchantMapper = merchantMapper;
        this.geoService = geoService;
        this.areaDivisionService = areaDivisionService;
        this.approveHistoryService = approveHistoryService;
        this.pushMsgIntegService = pushMsgIntegService;
    }

    @Override
    public PageWarper<MerchantBean> getMerchants(MerchantQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        List result = this.merchantMapper.queryByPageSize(param);
        for (MerchantBean entity : result) {
            String lastLevelFullName = this.areaDivisionService.getAreaDivisionDTO(this.getLastLevelCode((BaseMerchantBean)entity)).getFullName();
            if (!com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)lastLevelFullName)) continue;
            if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)entity.getDetailAddress())) {
                lastLevelFullName = lastLevelFullName + entity.getDetailAddress();
            }
            entity.setLastLevelAddress(lastLevelFullName);
        }
        return new PageWarper(result);
    }

    @Override
    public MerchantBean getMerchant(long id) {
        return this.merchantMapper.get(id);
    }

    @Override
    public Message save(MerchantParam param) {
        MerchantBean entity = this.convert(param);
        entity.setSourceType(SourceTypeEnum.ADD.name());
        entity.setAddTime(new Date());
        entity.setStatus(ApproveResultEnum.INIT.getCode());
        return Message.build((int)this.merchantMapper.insert(entity));
    }

    @Override
    public Message modify(MerchantParam param) {
        MerchantBean entity = this.convert(param);
        entity.setId(param.getId());
        return Message.build((int)this.merchantMapper.update(entity));
    }

    private MerchantBean convert(MerchantParam param) {
        MerchantBean entity = new MerchantBean();
        entity.setAddTime(new Date());
        BeanUtils.copyProperties((Object)param, (Object)entity);
        AreaDivisionDetailDTO countyInfo = this.areaDivisionService.getAreaDivisionDTO(param.getCountyCode());
        if (null != countyInfo) {
            entity.setDisplayAddress(countyInfo.getName() + param.getDetailAddress());
        }
        entity.setTownName(this.areaDivisionService.getAreaDivisionDTO(param.getTownCode()).getName());
        Coordinate location = this.getLocation(param);
        if (null != location) {
            entity.setLat(location.getLatitude().doubleValue());
            entity.setLng(location.getLongitude().doubleValue());
        }
        return entity;
    }

    private String getLastLevelCode(BaseMerchantBean merchant) {
        String lastLevelCode = merchant.getTownCode();
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)lastLevelCode)) {
            lastLevelCode = merchant.getCountyCode();
        }
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)lastLevelCode)) {
            lastLevelCode = merchant.getCityCode();
        }
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)lastLevelCode)) {
            lastLevelCode = merchant.getProvinceCode();
        }
        return lastLevelCode;
    }

    private Coordinate getLocation(MerchantParam param) {
        AreaDivisionDetailDTO lastLevel = this.areaDivisionService.getAreaDivisionDTO(this.getLastLevelCode((BaseMerchantBean)param));
        if (null != lastLevel) {
            String locationDetail = lastLevel.getFullName() + param.getDetailAddress();
            return this.geoService.getCoordinate(locationDetail);
        }
        return null;
    }

    @Override
    public List<MerchantBean> getTopMatch(String merchantName) {
        return this.merchantMapper.queryTopMatch(merchantName);
    }

    @Override
    public Message changeStatus(long id, int status, String rejectReason) {
        MerchantBean merchant = this.getMerchant(id);
        Message message = Message.build();
        if (null != merchant) {
            message.append(Message.build((int)this.merchantMapper.change(id, status)));
            if (status != 0) {
                message.append(this.approveHistoryService.save(ApproveTypeEnum.MERCHANT, ApproveResultEnum.get(status), id, rejectReason));
            }
            if (status != 0 && merchant.getUserId() > 0L) {
                PushMessage pushMessage = null;
                if (status == ApproveResultEnum.OK.getCode()) {
                    pushMessage = PushMessage.build((String)"\u5546\u5bb6\u4fe1\u606f\u5ba1\u6838\u901a\u8fc7", (String)"\u60a8\u7684\u4fe1\u606f\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u7a0d\u540e\u5c06\u6709\u5de5\u4f5c\u4eba\u5458\u8054\u7cfb\u60a8\uff0c\u8bf7\u4fdd\u6301\u7535\u8bdd\u7545\u901a\uff01", (Long)merchant.getUserId());
                    PushPayloadInfo payloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.ORDINARY_MSG);
                    pushMessage.setPayloadInfo(payloadInfo);
                } else if (status == ApproveResultEnum.REJECT.getCode()) {
                    String reason = StringUtils.isEmpty((Object)rejectReason) ? "" : ",\u539f\u56e0\u662f[" + rejectReason + "],\u53ef\u91cd\u65b0\u63d0\u4ea4\u5ba1\u6838\uff01";
                    pushMessage = PushMessage.build((String)"\u5546\u5bb6\u4fe1\u606f\u5ba1\u6838\u672a\u901a\u8fc7", (String)("\u60a8\u7684\u5546\u5bb6\u4fe1\u606f\u672a\u901a\u8fc7" + reason), (Long)merchant.getUserId());
                    PushPayloadInfo payloadInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.MERCHANT_VERIFY);
                    pushMessage.setPayloadInfo(payloadInfo);
                }
                if (null != pushMessage) {
                    this.pushMsgIntegService.pushMsg(pushMessage);
                }
            }
        }
        return message;
    }

    @Override
    public Message remove(long id) {
        return Message.build((int)this.merchantMapper.remove(id));
    }
}

