/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.PrivilegeStatusEnum;
import com.bxm.localnews.admin.domain.PrivilegeAreaMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.CommodityService;
import com.bxm.localnews.admin.service.MerchantService;
import com.bxm.localnews.admin.service.PrivilegeService;
import com.bxm.localnews.admin.service.ShortLinkService;
import com.bxm.localnews.admin.task.PrivilegeFinishTask;
import com.bxm.localnews.admin.task.PrivilegeStartTask;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.admin.vo.PrivilegeAreaBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeServiceImpl
extends BaseService
implements PrivilegeService {
    private PrivilegeMapper privilegeMapper;
    private ScheduleJobService scheduleJobService;
    private AliyunOSSService aliyunOSSService;
    private CommodityService commodityService;
    private HttpClientService httpClientService;
    private PrivilegeAreaMapper privilegeAreaMapper;
    private MerchantService merchantService;
    private ShortLinkService shortLinkService;
    private BizConfigProperties bizConfigProperties;

    @Autowired
    public PrivilegeServiceImpl(PrivilegeMapper privilegeMapper, PrivilegeAreaMapper privilegeAreaMapper, ScheduleJobService scheduleJobService, AliyunOSSService aliyunOSSService, CommodityService commodityService, HttpClientService httpClientService, ShortLinkService shortLinkService, BizConfigProperties bizConfigProperties) {
        this.privilegeMapper = privilegeMapper;
        this.scheduleJobService = scheduleJobService;
        this.aliyunOSSService = aliyunOSSService;
        this.commodityService = commodityService;
        this.httpClientService = httpClientService;
        this.privilegeAreaMapper = privilegeAreaMapper;
        this.shortLinkService = shortLinkService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public Message save(PrivilegeParam param) {
        PrivilegeBean entity = this.convert(param);
        entity.setDeleteFlag(0);
        entity.setAddTime(new Date());
        entity.setStatus(PrivilegeStatusEnum.BEGIN.getCode());
        this.saveAreaRelation(param, entity.getId());
        this.privilegeMapper.insert(entity);
        return Message.build((int)1);
    }

    private void setScheduleJob(PrivilegeBean entity) {
        PrivilegeStartTask startTask = new PrivilegeStartTask();
        String startJobId = startTask.getJobName() + "_" + entity.getId();
        startTask.setJobName(startJobId);
        startTask.setStartTime(entity.getStartTime());
        startTask.addParam("id", entity.getId());
        if (this.scheduleJobService.getJob(startTask.getJobName(), startTask.getGroup()) != null) {
            this.scheduleJobService.remove(startTask.getJobName(), startTask.getGroup());
        }
        this.scheduleJobService.addSimpleJob((AbstractCustomJob)startTask);
        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + entity.getId();
        endTask.setJobName(endJobId);
        endTask.setStartTime(entity.getEndTime());
        endTask.addParam("id", entity.getId());
        if (this.scheduleJobService.getJob(endTask.getJobName(), endTask.getGroup()) != null) {
            this.scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
        }
        this.scheduleJobService.addSimpleJob((AbstractCustomJob)endTask);
    }

    private void setFinishJob(PrivilegeBean entity) {
        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + entity.getId();
        endTask.setJobName(endJobId);
        endTask.setStartTime(entity.getEndTime());
        endTask.addParam("id", entity.getId());
        if (this.scheduleJobService.getJob(endTask.getJobName(), endTask.getGroup()) != null) {
            this.scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
        }
        this.scheduleJobService.addSimpleJob((AbstractCustomJob)endTask);
    }

    private void saveAreaRelation(PrivilegeParam param, final long id) {
        this.privilegeAreaMapper.deleteByPrivilegeId(Long.valueOf(id));
        if (param.getGlobalFlag() == 1) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCodes())) {
            String[] relationCodeArray = StringUtils.split((String)param.getAreaCodes(), (String)",");
            new BatchHelper<PrivilegeAreaMapper, String>(PrivilegeAreaMapper.class, relationCodeArray){

                protected int invoke(String element) {
                    PrivilegeAreaBean privilegeAreaBean = new PrivilegeAreaBean();
                    privilegeAreaBean.setId(Long.valueOf(PrivilegeServiceImpl.this.nextId()));
                    privilegeAreaBean.setAreaCode(element);
                    privilegeAreaBean.setPrivilegeId(Long.valueOf(id));
                    return ((PrivilegeAreaMapper)this.mapper).insert(privilegeAreaBean);
                }
            };
        }
    }

    @Override
    public Message modify(PrivilegeParam param) {
        Message message = Message.build((int)1);
        PrivilegeBean entity = this.convert(param);
        this.saveAreaRelation(param, entity.getId());
        this.privilegeMapper.updateByPrimaryKey(entity);
        return message;
    }

    private PrivilegeBean convert(PrivilegeParam param) {
        PrivilegeBean entity = new PrivilegeBean();
        BeanUtils.copyProperties((Object)param, (Object)entity);
        if (param.getId() <= 0L) {
            entity.setId(this.nextId());
        }
        if (param.getCommodityId() > 0L) {
            CommodityBean commodityDetail = this.commodityService.get(param.getCommodityId());
            if (null != commodityDetail) {
                entity.setMerchantId(commodityDetail.getMechantId());
            } else {
                this.logger.error("\u5546\u54c1[{}]\u5df2\u88ab\u5220\u9664\uff0c\u5173\u8054\u6d3b\u52a8\u7684\u5546\u54c1\u4e0d\u5141\u8bb8\u5220\u9664", (Object)param.getCommodityId());
            }
        }
        return entity;
    }

    @Override
    public PageWarper<PrivilegeBean> queryByPage(PrivilegeQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.privilegeMapper.queryByPageSize(param));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setPrivilegeAreas(this.privilegeAreaMapper.getPrivilegeAreas(Long.valueOf(privilegeBean.getId()))));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setShortUrl4QRCode(this.shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId() + "&posterFlag=chook")));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setShortUrl4Poster(this.shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId())));
        return pageWarper;
    }

    @Override
    public PrivilegeBean get(long id) {
        PrivilegeBean entity = this.privilegeMapper.selectByPrimaryKey(Long.valueOf(id));
        entity.setPrivilegeAreas(this.privilegeAreaMapper.getPrivilegeAreas(Long.valueOf(entity.getId())));
        return entity;
    }

    @Override
    public Message remove(long id) {
        PrivilegeBean entity = this.get(id);
        if (entity.getStatus() != PrivilegeStatusEnum.FINISH.getCode()) {
            return Message.build((boolean)false).setMessage("\u6d3b\u52a8\u5f53\u524d\u5904\u4e8e\u672a\u7ed3\u675f\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        Message message = Message.build((int)this.privilegeMapper.deleteByPrimaryKey(Long.valueOf(id)));
        if (message.isSuccess()) {
            this.removeTask(id);
        }
        return message;
    }

    private void removeTask(long privilegeId) {
        PrivilegeStartTask startTask = new PrivilegeStartTask();
        String startJobId = startTask.getJobName() + "_" + privilegeId;
        this.scheduleJobService.remove(startTask.getJobName(), startTask.getGroup());
        PrivilegeFinishTask endTask = new PrivilegeFinishTask();
        String endJobId = endTask.getJobName() + "_" + privilegeId;
        this.scheduleJobService.remove(endTask.getJobName(), endTask.getGroup());
    }

    @Override
    public Message changeEnable(long id, int status) {
        this.privilegeMapper.changeEnable(id, status);
        if (status == 0) {
            this.removeTask(id);
        } else if (status == 1) {
            PrivilegeBean privilegeBean = this.get(id);
        }
        return Message.build((boolean)true);
    }

    @Override
    public Message changeOrder(long id, int order) {
        this.privilegeMapper.changeOrder(id, order);
        return Message.build((boolean)true);
    }
}

