/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.service.ShortLinkService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkServiceImpl
implements ShortLinkService {
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public ShortLinkServiceImpl(BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String getShortUrl(String url, boolean expired) {
        StringBuilder sortUrl = new StringBuilder();
        String host = this.bizConfigProperties.getServerHost();
        sortUrl.append(host).append("/").append("t").append("/");
        String key = ShortUrlGenerator.getShortUrl((String)url)[0];
        sortUrl.append(key);
        if (expired) {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url, 7776000L);
        } else {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url);
        }
        return sortUrl.toString();
    }

    @Override
    public String getPrivilegeShareShortLink(String param) {
        String url = null;
        url = this.bizConfigProperties.getPrivilegeShareUrl() + "?" + param;
        return this.getShortUrl(url, true);
    }
}

