/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.impl;

import com.bxm.localnews.admin.domain.AdminNewsMapper;
import com.bxm.localnews.admin.domain.AdminVideoBlackMapper;
import com.bxm.localnews.admin.domain.AdminVideoMapper;
import com.bxm.localnews.admin.param.NewsBlackParam;
import com.bxm.localnews.admin.service.VideoService;
import com.bxm.localnews.admin.vo.GlobalVideoBlackEntity;
import com.bxm.localnews.admin.vo.Video;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Calendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VideoServiceImpl
implements VideoService {
    private AdminVideoMapper adminVideoMapper;
    private AdminVideoBlackMapper adminVideoBlackMapper;

    @Autowired
    public VideoServiceImpl(AdminVideoMapper adminVideoMapper, AdminVideoBlackMapper adminVideoBlackMapper, AdminNewsMapper adminNewsMapper) {
        this.adminVideoMapper = adminVideoMapper;
        this.adminVideoBlackMapper = adminVideoBlackMapper;
    }

    @Override
    public PageWarper<Video> findVideoByTitleAndStatus(NewsBlackParam param) {
        return new PageWarper(this.adminVideoMapper.selectByTitleAndStatus(param));
    }

    @Override
    @Transactional
    public void addVideoBlack(Long id, String remark) {
        GlobalVideoBlackEntity entity = new GlobalVideoBlackEntity();
        entity.setCreateTime(Calendar.getInstance().getTime());
        entity.setRemark(remark);
        entity.setType(Integer.valueOf(0));
        entity.setVideoId(id);
        this.adminVideoBlackMapper.insert(entity);
        this.adminVideoMapper.updateVideoStatus(id, Integer.valueOf(0));
    }
}

