/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.strategy;

import com.bxm.localnews.admin.service.strategy.DrawStrategyService;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.vo.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DrawStrategDispatcher
implements InitializingBean,
ApplicationContextAware,
DrawStrategyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawStrategDispatcher.class);
    private ApplicationContext applicationContext;
    private Map<String, DrawStrategyService> strategyMap;

    public void afterPropertiesSet() {
        this.strategyMap = this.applicationContext.getBeansOfType(DrawStrategyService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Message execDraw(PrivilegeBean privilege) {
        if (null == privilege) {
            return Message.build((boolean)false).setMessage("\u6d3b\u52a8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String strategy = privilege.getStrategy();
        DrawStrategyService service = this.strategyMap.get(strategy);
        if (null == service) {
            String loggerMsg = "\u6d3b\u52a8ID" + privilege.getId() + "\u914d\u7f6e\u7684\u7b56\u7565[" + strategy + "]\u4e0d\u5b58\u5728";
            return Message.build((boolean)false).setMessage(loggerMsg);
        }
        return this.strategyMap.get(strategy).execDraw(privilege);
    }
}

