/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.strategy;

import com.bxm.localnews.admin.domain.ParticipantMapper;
import com.bxm.localnews.admin.service.strategy.AbstractDrawStrategyService;
import com.bxm.localnews.admin.vo.ParticipantBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component(value="toponeStrategy")
@RefreshScope
public class TopOneDrawStrategyServiceImpl
extends AbstractDrawStrategyService {
    private final ParticipantMapper participantMapper;

    @Autowired
    public TopOneDrawStrategyServiceImpl(ParticipantMapper participantMapper) {
        this.participantMapper = participantMapper;
    }

    @Override
    Message draw(PrivilegeBean privilege) {
        int prizeNum = privilege.getPrizeNum();
        HashSet<Long> winners = new HashSet<Long>(prizeNum);
        ArrayList relationWinners = Lists.newArrayList();
        ParticipantBean topParticipant = this.participantMapper.getTopUser(privilege.getId());
        List participants = this.participantMapper.getParticipantList(privilege.getId());
        int count = participants.size();
        if (topParticipant != null && topParticipant.getInviteCount() >= privilege.getLessInviteNum()) {
            winners.add(topParticipant.getUserId());
            participants.removeIf(entity -> Objects.equals(entity.getUserId(), topParticipant.getUserId()));
            --prizeNum;
            this.logger.debug("\u9996\u540d\u4e2d\u5956\uff0c\u6d3b\u52a8\u662f[{}],\u4e2d\u5956\u4eba\u662f[{}]", (Object)privilege.getId(), (Object)topParticipant.getUserId());
        } else {
            this.logger.info("\u6d3b\u52a8[{}]\u8981\u6c42\u9996\u540d\u9080\u8bf7\u4eba\u6570\u8fbe\u5230[{}],\u5b9e\u9645\u9080\u8bf7\u4eba\u6570[{}]", new Object[]{privilege.getId(), privilege.getLessInviteNum(), count});
        }
        if (count <= prizeNum) {
            this.logger.info("\u6d3b\u52a8[{}]\u5b9e\u9645\u53c2\u4e0e\u4eba\u6570[{}],\u6d3e\u5956\u6570\u91cf[{}],\u6240\u6709\u53c2\u4e0e\u4eba\u5747\u4e2d\u5956", new Object[]{privilege.getId(), count, prizeNum});
            for (ParticipantBean participant : participants) {
                winners.add(participant.getUserId());
            }
            participants = Lists.newArrayList();
        } else {
            while (prizeNum != 0) {
                if (prizeNum == 1) {
                    long singalUserId = this.getSignalWinner(participants);
                    if (singalUserId > 0L) {
                        winners.add(singalUserId);
                        participants.removeIf(entity -> Objects.equals(singalUserId, entity.getUserId()));
                        break;
                    }
                    this.logger.info("\u6d3b\u52a8[{}]\u53c2\u4e0e\u4eba\u4e2d\u65e0\u5269\u4f59\u7684\u5355\u4e2a\u53c2\u4e0e\u4eba\u5458\uff0c\u653e\u5f03\u62bd\u53d6\u6700\u540e\u4e00\u4f4d\u4e2d\u5956\u7528\u6237", (Object)privilege.getId());
                    break;
                }
                count = participants.size();
                int randomNum = RandomUtils.nextInt((int)0, (int)(count - 1));
                ParticipantBean randomWinner = (ParticipantBean)participants.remove(randomNum);
                if (winners.add(randomWinner.getUserId())) {
                    --prizeNum;
                }
                if (randomWinner.getInviteUserId() == null || randomWinner.getInviteUserId() == 0L || !winners.add(randomWinner.getInviteUserId())) continue;
                relationWinners.add(randomWinner);
                participants.removeIf(entity -> Objects.equals(entity.getUserId(), randomWinner.getInviteUserId()));
                --prizeNum;
            }
        }
        this.saveWinner(privilege, winners, relationWinners, participants);
        privilege.setActualNum(winners.size());
        return Message.build((boolean)true);
    }

    private long getSignalWinner(List<ParticipantBean> participants) {
        List signalUsers = participants.stream().filter(entity -> entity.getInviteUserId() == null || entity.getInviteUserId() == 0L).collect(Collectors.toList());
        if (signalUsers.size() > 0) {
            int randomNum = RandomUtils.nextInt((int)0, (int)(signalUsers.size() - 1));
            return ((ParticipantBean)signalUsers.get(randomNum)).getUserId();
        }
        return 0L;
    }
}

