package com.bxm.localnews.admin.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.convert.Converter;
import com.bxm.localnews.admin.param.BaseCashParam;
import com.bxm.localnews.admin.param.CashParam;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author: gengyy
 * @create: 2020-10-21 18:42
 */
@Component
public class SendCashConvert implements Converter<CashParam, List<BaseCashParam.UserCash>> {

    @Override
    public List<BaseCashParam.UserCash> convert(CashParam data) {
        String template = data.getTemplate();
        List<String> templates = JSONObject.parseArray(template, String.class);
        List<BaseCashParam.UserCash> result = Lists.newArrayList();
        templates.stream().forEach(e -> {
            BaseCashParam.UserCash userCash = new BaseCashParam.UserCash();
            if (StringUtils.isNotBlank(e)) {
                String[] info = e.split(",");
                userCash.setUserId(NumberUtils.toLong(info[0]));
                double cash = NumberUtils.toDouble(info[1]);
                userCash.setCashNum(cash);
                result.add(userCash);
            }
        });
        return result;
    }
}
