package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.PointMallMapper;
import com.bxm.localnews.admin.param.PointMallParam;
import com.bxm.localnews.admin.service.activity.PointMallService;
import com.bxm.localnews.admin.vo.PointMall;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/15 14:55
 * @desc
 */
@Service
public class PointMallServiceImpl implements PointMallService {

    private RedisStringAdapter redisStringAdapter;

    private SequenceCreater sequenceCreater;

    private PointMallMapper pointMallMapper;

    @Autowired
    public PointMallServiceImpl(RedisStringAdapter redisStringAdapter, SequenceCreater sequenceCreater,
                                PointMallMapper pointMallMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.sequenceCreater = sequenceCreater;
        this.pointMallMapper = pointMallMapper;
    }

    @Override
    public PageWarper<PointMall> queryPointMalls(PointMallParam param) {
        return new PageWarper<>(pointMallMapper.queryPointMalls(param));
    }

    @Override
    public PointMall selectByPrimaryKey(Long id) {
        return pointMallMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updatePointMallStatus(Long id, Byte status) {
        PointMall pointMall = this.pointMallMapper.selectByPrimaryKey(id);
        if (pointMall == null) {
            return 0;
        }
        pointMall.setStatus(status);
        this.pointMallMapper.updateByPrimaryKeySelective(pointMall);
        removeCache();

        return 1;
    }

    @Override
    public int addPointMall(PointMall pointMall) {
        Long pointMallId = pointMall.getId();
        if (pointMallId == null) {
            pointMallId = sequenceCreater.nextLongId();
        }

        int update;
        if (pointMall.getId() == null) {
            pointMall.setId(pointMallId);
            update = this.pointMallMapper.insertSelective(pointMall);
        } else {
            update = this.pointMallMapper.updateByPrimaryKeySelective(pointMall);
        }

        removeCache();

        return update;
    }

    @Override
    public int remove(Long id) {
        int update = this.pointMallMapper.deleteByPrimaryKey(id);
        removeCache();

        return update;
    }

    /**
     * 获取积分商城列表的key
     * @return
     */
    private KeyGenerator getPointsMallListKey() {
        return RedisConfig.POINTS_MALL_KEY.copy().appendKey("list");
    }

    /**
     * 移除缓存
     */
    private void removeCache() {
        redisStringAdapter.remove(this.getPointsMallListKey());
    }
}
