package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.enums.RedPacketShareType;
import com.bxm.localnews.admin.domain.RedPacketContentMapper;
import com.bxm.localnews.admin.domain.RedPacketItemMapper;
import com.bxm.localnews.admin.domain.RedPacketShareMapper;
import com.bxm.localnews.admin.dto.RedPacketConfigDTO;
import com.bxm.localnews.admin.dto.RedPacketContentDTO;
import com.bxm.localnews.admin.param.RedPacketConfigParam;
import com.bxm.localnews.admin.service.activity.RedPacketConfigService;
import com.bxm.localnews.admin.vo.RedPacketContent;
import com.bxm.localnews.admin.vo.RedPacketItem;
import com.bxm.localnews.admin.vo.RedPacketShare;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class RedPacketConfigServiceImpl implements RedPacketConfigService {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketConfigServiceImpl.class);

    /**
     * 口令模板数据接口层
     */
    private RedPacketContentMapper redPacketContentMapper;

    /**
     * 红包分享配置 数据接口层
     */
    private RedPacketShareMapper redPacketShareMapper;

    /**
     * 红包item 数据接口层
     */
    private RedPacketItemMapper redPacketItemMapper;
    /**
     * 序列号创建服务
     */
    private SequenceCreater sequenceCreater;

    @Autowired
    public RedPacketConfigServiceImpl(RedPacketContentMapper redPacketContentMapper, SequenceCreater sequenceCreater,
                                      RedPacketShareMapper redPacketShareMapper, RedPacketItemMapper redPacketItemMapper) {
        this.redPacketContentMapper = redPacketContentMapper;
        this.sequenceCreater = sequenceCreater;
        this.redPacketShareMapper = redPacketShareMapper;
        this.redPacketItemMapper = redPacketItemMapper;
    }

    @Override
    public boolean editRedPacketContent(Long id, String content) {

        RedPacketContent redPacketContentEntity = new RedPacketContent();
        redPacketContentEntity.setId(id);
        redPacketContentEntity.setContent(content);

        return executeSucBySingle(redPacketContentMapper.updateByPrimaryKeySelective(redPacketContentEntity));
    }

    @Override
    public RedPacketContentDTO getContentDetail(Long id) {

        RedPacketContent redPacketContent = redPacketContentMapper.selectByPrimaryKey(id);
        if (null == redPacketContent) {
            LOG.error("以id:{}获取口令模板为空", id);
            return null;
        }

        RedPacketContentDTO resultDTO = new RedPacketContentDTO();
        BeanUtils.copyProperties(redPacketContent, resultDTO);
        return resultDTO;
    }

    @Override
    public PageWarper<RedPacketContentDTO> getContentList(RedPacketContentDTO redPacketContentDTO) {
        return new PageWarper<>(redPacketContentMapper.queryList(redPacketContentDTO));
    }

    @Override
    public boolean addContent(String content) {
        RedPacketContent redPacketContentEntity = new RedPacketContent();
        redPacketContentEntity.setId(sequenceCreater.nextLongId());
        redPacketContentEntity.setContent(content);
        redPacketContentEntity.setCreateTime(new Date());

        //新增
        return executeSucBySingle(redPacketContentMapper.insertSelective(redPacketContentEntity));
    }

    @Override
    public boolean delContent(Long id) {
        LOG.info("删除id为:{}的口令模板", id);

        return executeSucBySingle(redPacketContentMapper.deleteByPrimaryKey(id));
    }

    @Override
    public boolean addRedPacketConfig(RedPacketConfigParam redPacketConfigParam) {


        //设置红包数额和个数 模板
        redPacketConfigParam.getRedPacketItemList().forEach(redPacketItem -> {
            //设置红包金额模板
            RedPacketItem redPacketItemEntity = new RedPacketItem();
            redPacketItemEntity.setId(sequenceCreater.nextLongId());
            redPacketItemEntity.setAmount(redPacketItem.getAmount());
            redPacketItemEntity.setNum(redPacketItem.getNum());
            redPacketItemMapper.insertSelective(redPacketItemEntity);
        });

        //设置未领取红包分享语言
        insertShareList(redPacketConfigParam.getRedPacketShareListWithout());


        //设置已领取红包分享语言
        insertShareList(redPacketConfigParam.getRedPacketShareList());

        return true;
    }

    @Override
    public RedPacketConfigDTO getRedPacketConfig() {
        RedPacketConfigDTO resultDTO = new RedPacketConfigDTO();
        //获取红包金额模板
        List<RedPacketItem> redPacketItemList = getRedPacketItem();
        resultDTO.setRedPacketItemList(redPacketItemList);

        //获取未领取分享语List
        List<RedPacketShare> redPacketShareListWithout = getRedPacketShareList(RedPacketShareType.UNRECEIVED.getCode());
        resultDTO.setRedPacketShareListWithout(redPacketShareListWithout);

        //获取已领取分享语List
        List<RedPacketShare> redPacketShareList = getRedPacketShareList(RedPacketShareType.ALREADY_RECEIVE.getCode());
        resultDTO.setRedPacketShareList(redPacketShareList);
        return resultDTO;
    }

    @Override
    public boolean editRedPacketConfig(RedPacketConfigParam redPacketConfigParam) {
        editRedPacketItem(redPacketConfigParam.getRedPacketItemList());

        //更新分享话术
        updateShareList(redPacketConfigParam.getRedPacketShareList());
        updateShareList(redPacketConfigParam.getRedPacketShareListWithout());

        return true;
    }

    /**
     * 分享语List塞入数据库
     *
     * @param shareList 分享与List
     * @return 执行结果
     */
    private boolean insertShareList(List<RedPacketShare> shareList) {
        shareList.forEach(redPacketShare -> {
            RedPacketShare redPacketShareEntity = new RedPacketShare();
            redPacketShareEntity.setId(sequenceCreater.nextLongId());
            redPacketShareEntity.setContent(redPacketShare.getContent());
            redPacketShareEntity.setImgUrl(redPacketShare.getImgUrl());
            redPacketShareEntity.setType(redPacketShare.getType());
            redPacketShareEntity.setCreateTime(new Date());

            redPacketShareMapper.insertSelective(redPacketShareEntity);
        });

        return true;
    }

    private boolean updateShareList(List<RedPacketShare> shareList) {
        shareList.forEach(redPacketShare -> {

            Long id = redPacketShare.getId();
            RedPacketShare queryRedPacketShare = redPacketShareMapper.selectByPrimaryKey(id);
            if (queryRedPacketShare.getContent().equals(redPacketShare.getContent())) {
                return;
            }

            //删除原有话语,delete_flag置为1
            redPacketShareMapper.deleteByPrimaryKey(id);

            //组装参数
            RedPacketShare redPacketShareEntity = new RedPacketShare();
            redPacketShareEntity.setId(sequenceCreater.nextLongId());
            redPacketShareEntity.setContent(redPacketShare.getContent());
            redPacketShareEntity.setImgUrl(redPacketShare.getImgUrl());
            redPacketShareEntity.setType(redPacketShare.getType());
            redPacketShareEntity.setCreateTime(new Date());

            //新增
            redPacketShareMapper.insertSelective(redPacketShareEntity);
        });
        return true;
    }


    private List<RedPacketItem> getRedPacketItem() {
        return redPacketItemMapper.queryList();
    }

    private List<RedPacketShare> getRedPacketShareList(Integer type) {
        return redPacketShareMapper.queryListByType(type);
    }

    private boolean editRedPacketItem(List<RedPacketItem> redPacketItemList) {
        redPacketItemList.forEach(redPacketItem -> {
            RedPacketItem redPacketItemEntity = new RedPacketItem();
            redPacketItemEntity.setId(redPacketItem.getId());
            redPacketItemEntity.setNum(redPacketItem.getNum());
            redPacketItemEntity.setAmount(redPacketItem.getAmount());
            redPacketItemMapper.updateByPrimaryKeySelective(redPacketItemEntity);
        });

        return true;
    }

    /**
     * 校验更新/新增单条数据是否成功
     *
     * @param updateResult 更新结果
     * @return 校验结果, 更新单条数据结果为1则返回true 否则返回false
     */
    private boolean executeSucBySingle(int updateResult) {
        return 1 == updateResult;
    }
}
