package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.admin.domain.TaskMapper;
import com.bxm.localnews.admin.param.TaskParam;
import com.bxm.localnews.admin.service.activity.TaskService;
import com.bxm.localnews.admin.vo.TaskBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl extends BaseService implements TaskService {

    private TaskMapper taskMapper;


    @Autowired
    public TaskServiceImpl(TaskMapper taskMapper) {
        this.taskMapper = taskMapper;
    }

    @Override
    public Message modifyTaskStatus(Byte state, String... taskIds) {
        if (ArrayUtils.isEmpty(taskIds)) {
            return Message.build(false).setMessage("请选择变更状态的任务");
        }

        boolean saveResult = new BatchHelper<TaskMapper, String>(TaskMapper.class, taskIds,
                "primarySessionTemplate") {
            @Override
            protected int invoke(String element) {
                return this.mapper.changeStatus(element, state);
            }
        }.success();
        return Message.build(saveResult);
    }

    @Override
    public PageWarper<TaskBean> queryTaskByPage(TaskParam param) {
        return new PageWarper<>(taskMapper.getTaskByPageSize(param));
    }

    @Override
    public TaskBean getTaskById(Long taskId) {
        return taskMapper.selectByPrimaryKey(taskId);
    }

}
