package com.bxm.localnews.admin.service.activity.strategy;

import java.util.Map;

import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.newidea.component.vo.Message;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/4/2 17:56
 * @desc
 */
@Component
@Slf4j
public class PushCodeDispatcher implements InitializingBean, ApplicationContextAware, PushCodeService {

    private ApplicationContext applicationContext;

    private Map<String, PushCodeService> strategyMap;

    @Override
    public void afterPropertiesSet() {
        strategyMap = applicationContext.getBeansOfType(PushCodeService.class);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Message execPushCode(AreaPushCode areaPushCode, String codeUrl) {

        String templateCode = areaPushCode.getCodeTemplate();

        PushCodeService pushCodeService = strategyMap.get(templateCode);
        if (null == pushCodeService) {
            log.error("配置的策略[" + templateCode + "]不存在");
            return null;
        }

        return strategyMap.get(templateCode).execPushCode(areaPushCode, codeUrl);
    }
}
