package com.bxm.localnews.admin.service.activity.strategy;

import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import com.bxm.localnews.admin.vo.AreaPushCode;

import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/4/2 17:31
 * @desc
 */
@Service("qrcode")
public class QrcodeServiceImpl extends AbstractPushCodeService {


    @Override
    File generateQrcode(AreaPushCode areaPushCode, String codeUrl) {
        try {
            return genPushCode(areaPushCode.getId().toString(), areaPushCode.getCodeUrl());
        } catch (IOException e) {
            logger.error("二维码生成失败");
            return null;
        }
    }

    /**
     * 生成二维码
     *
     * @param code
     * @return
     * @throws IOException
     */
    private File genPushCode(String code, String codeUrl) throws IOException {
        String suffix = "png";
        gen(code, codeUrl, 200, 200);
        //生成文件
        String finalFileName = code + "_final." + suffix;
        File finalFile = new File(getRootPath() + finalFileName);
        return finalFile;
    }
}
