package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.AppVersionDTO;
import com.bxm.localnews.admin.param.AppVersionParam;
import com.bxm.localnews.admin.vo.AppVersion;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author zhaoyadong 2019/1/10 15:06
 * @desc
 */
public interface AdminAppVersionService {

    /**
     * 查询版本列表
     * @param appVersionParam 版本参数
     * @return 分页结果
     */
    PageWarper<AppVersionDTO> getAppVersionList(AppVersionParam appVersionParam);

    /**
     * 查询版本详情
     * @param id
     * @return
     */
    AppVersionDTO getAppVersionById(Long id);

    /**
     * 批量更新审核状态
     * @param ids
     * @param status
     * @return
     */
    int updateAppVersionStatusById(String[] ids, Byte status, Byte force);

    /**
     * 更新审核状态
     * @param appVersion
     * @return
     */
    int updateAppVersionStatusById(AppVersion appVersion);

    /**
     * 新增或编辑版本信息
     * @param appVersion
     * @return
     */
    int addAppVersionDetail(AppVersion appVersion);
}
