package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.param.UserBecomeTalentParam;
import com.bxm.localnews.admin.param.talent.TalentListQueryParam;
import com.bxm.localnews.admin.param.talent.UpgradeTalentParam;
import com.bxm.localnews.admin.vo.talent.TalentListVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 达人管理service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/14 2:41 下午
 */
public interface TalentMangeService {
    /**
     * 获取达人列表
     *
     * @param param 达人查询入参
     * @return 达人信息分页列表
     */
    PageWarper<TalentListVO> getTalentList(TalentListQueryParam param);

    /**
     * 提升达人等级
     *
     * @param param 提升等级入参
     * @return 执行结果
     */
    Message upgradeTalent(UpgradeTalentParam param);

    /**
     * 普通用户升级为达人
     *
     * @param param 入参
     * @return 执行结果
     */
    Message becomeTalent(UserBecomeTalentParam param);
}